/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.config.internal.validation;

import java.io.File;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.ComponentParameterAst;
import org.mule.runtime.ast.api.util.ComponentAstPredicatesFactory;
import org.mule.runtime.ast.api.validation.Validation;
import org.mule.runtime.ast.api.validation.ValidationResultItem;
import org.mule.runtime.config.internal.dsl.utils.DslConstants;

public abstract class AbstractEeTransformResourceExists
implements Validation {
    private static final ComponentIdentifier EE_TRANSFORM_IDENTIFIER = ComponentIdentifier.builder().namespace("ee").namespaceUri(DslConstants.EE_NAMESPACE).name("transform").build();
    private final ClassLoader artifactRegionClassLoader;

    public AbstractEeTransformResourceExists(ClassLoader artifactRegionClassLoader) {
        this.artifactRegionClassLoader = artifactRegionClassLoader;
    }

    public final ClassLoader getArtifactRegionClassLoader() {
        return this.artifactRegionClassLoader;
    }

    @Override
    public final String getName() {
        return "'ee:transform' resources exist";
    }

    @Override
    public final String getDescription() {
        return "DataWeave script files referenced in 'ee:transform' exist and are accessible.";
    }

    @Override
    public final Validation.Level getLevel() {
        return Validation.Level.ERROR;
    }

    @Override
    public final Predicate<List<ComponentAst>> applicable() {
        return ComponentAstPredicatesFactory.currentElemement(comp -> comp.getIdentifier().equals(EE_TRANSFORM_IDENTIFIER) && this.applicableInner((ComponentAst)comp));
    }

    protected abstract boolean applicableInner(ComponentAst var1);

    protected final Optional<ValidationResultItem> validateResourceExists(ComponentAst component, ComponentParameterAst resourceParam, String resource) {
        if (this.getArtifactRegionClassLoader().getResource(resource) == null && !new File(resource).exists()) {
            return Optional.of(ValidationResultItem.create(component, resourceParam, (Validation)this, "Invalid configuration found for parameter 'resource': " + resource));
        }
        return Optional.empty();
    }
}

