/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.core.api.license;

import com.mulesoft.licm.EnterpriseLicenseKey;
import com.mulesoft.licm.LicenseManagementFactory;
import com.mulesoft.licm.impl.MuleLicenseKey;
import com.mulesoft.mule.runtime.core.api.license.MuleLicense;
import com.mulesoft.mule.runtime.core.api.license.NoValidLicenseFoundException;

public class MuleLicenseUtils {
    private static boolean isBypassLicenseCheck = false;

    private MuleLicenseUtils() {
    }

    public static MuleLicense getLicense() throws NoValidLicenseFoundException {
        return MuleLicenseUtils.isBypassLicenseCheck() ? MuleLicenseUtils.getDefaultEvaluationLicense() : MuleLicenseUtils.getInstalledLicense();
    }

    private static MuleLicense getInstalledLicense() throws NoValidLicenseFoundException {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(MuleLicenseUtils.class.getClassLoader());
            EnterpriseLicenseKey licenseKey = LicenseManagementFactory.getInstance().createLicenseManager("mule-ee").validate("mule-ee");
            MuleLicense muleLicense = new MuleLicense(licenseKey);
            return muleLicense;
        }
        catch (Exception e) {
            throw new NoValidLicenseFoundException("Invalid EE license");
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
    }

    private static MuleLicense getDefaultEvaluationLicense() {
        try {
            return MuleLicenseUtils.getInstalledLicense();
        }
        catch (Exception e) {
            MuleLicenseKey muleLicenseKey = new MuleLicenseKey();
            muleLicenseKey.setEvaluation(true);
            return new MuleLicense(muleLicenseKey);
        }
    }

    static boolean isBypassLicenseCheck() {
        return isBypassLicenseCheck;
    }

    public static void setIsBypassLicenseCheck(boolean isBypassLicenseCheck) {
        MuleLicenseUtils.isBypassLicenseCheck = isBypassLicenseCheck;
    }
}

