/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.core.api.util.license;

import com.mulesoft.licm.EnterpriseLicenseKey;
import com.mulesoft.licm.LicenseKeyException;
import com.mulesoft.licm.LicenseManagementFactory;
import com.mulesoft.licm.feature.Feature;
import com.mulesoft.licm.feature.FeatureValidator;
import com.mulesoft.licm.impl.MuleLicenseInterrupter;
import com.mulesoft.mule.runtime.core.api.util.license.LicenseKey;
import com.mulesoft.mule.runtime.core.api.util.license.MuleLicenseException;
import de.schlichtherle.license.LicenseContentException;
import java.util.function.Supplier;

public class LicenseUtils {
    public static final String MULE_EE = "mule-ee";
    private static final boolean TESTING_MODE_ENABLED = System.getProperty("mule.testingMode") != null;
    private static final LicenseProvider licenseProvider = new LicenseProvider(new LicenceKeyProviderImpl(), new InterrupterImpl(), () -> TESTING_MODE_ENABLED);

    public static LicenseKey getLicenseKey(String product) throws MuleLicenseException {
        return licenseProvider.getLicenseKey(product);
    }

    private LicenseUtils() {
    }

    private static class InterrupterImpl
    implements Interrupter {
        private InterrupterImpl() {
        }

        @Override
        public void interruptDefer(Exception e) {
            MuleLicenseInterrupter.interrupt(e);
        }
    }

    static interface Interrupter {
        public void interruptDefer(Exception var1);
    }

    private static class LicenceKeyProviderImpl
    implements LicenseKeyProvider {
        private LicenceKeyProviderImpl() {
        }

        @Override
        public LicenseKey getLicenseKey(String product) throws LicenseKeyException {
            return new DefaultLicenseKey(LicenseManagementFactory.getInstance().createLicenseManager(LicenseUtils.MULE_EE).validate(product));
        }
    }

    static interface LicenseKeyProvider {
        public LicenseKey getLicenseKey(String var1) throws LicenseKeyException;
    }

    static class TestingLicenseKey
    implements LicenseKey {
        private TestingLicenseKey() {
        }

        @Override
        public void validateFeature(String featureId, String featureName) {
        }
    }

    private static class DefaultLicenseKey
    implements LicenseKey {
        private final EnterpriseLicenseKey license;

        public DefaultLicenseKey(EnterpriseLicenseKey license) {
            this.license = license;
        }

        @Override
        public void validateFeature(String featureId, String featureName) throws MuleLicenseException {
            if (!this.license.isEvaluation()) {
                try {
                    new FeatureValidator(new Feature(featureId, featureName)).validate(this.license);
                }
                catch (LicenseContentException e) {
                    throw new MuleLicenseException(e.getMessage(), (Exception)((Object)e));
                }
            }
        }
    }

    static class LicenseProvider {
        public static final String UNEXPECTED_ERROR_ON_LICENSE_VALIDATION = "Unexpected error on license validation";
        private final LicenseKeyProvider licenseKeyProvider;
        private final Interrupter interrupter;
        private final Supplier<Boolean> testingModeEvaluator;

        LicenseProvider(LicenseKeyProvider licenseKeyProvider, Interrupter interrupter, Supplier<Boolean> testingModeEvaluator) {
            this.licenseKeyProvider = licenseKeyProvider;
            this.interrupter = interrupter;
            this.testingModeEvaluator = testingModeEvaluator;
        }

        public LicenseKey getLicenseKey(String product) throws MuleLicenseException {
            ClassLoader originalTccl = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(LicenseManagementFactory.class.getClassLoader());
            try {
                LicenseKey licenseKey = this.licenseKeyProvider.getLicenseKey(product);
                return licenseKey;
            }
            catch (LicenseKeyException e) {
                throw new MuleLicenseException(e.getMessage(), e);
            }
            catch (Exception e) {
                MuleLicenseException wrappedException = new MuleLicenseException(UNEXPECTED_ERROR_ON_LICENSE_VALIDATION, e);
                if (this.testingModeEvaluator.get().booleanValue()) {
                    this.interrupter.interruptDefer(e);
                    TestingLicenseKey testingLicenseKey = new TestingLicenseKey();
                    return testingLicenseKey;
                }
                throw wrappedException;
            }
            finally {
                Thread.currentThread().setContextClassLoader(originalTccl);
            }
        }
    }
}

