/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.core.internal.config.scheduler;

import com.mulesoft.mule.runtime.core.internal.config.scheduler.SchedulerPoolsArtifactConfig;
import java.util.Optional;
import org.mule.runtime.api.component.AbstractComponent;
import org.mule.runtime.api.scheduler.SchedulerPoolStrategy;
import org.mule.runtime.api.scheduler.SchedulerPoolsConfig;
import org.mule.runtime.api.scheduler.SchedulerPoolsConfigFactory;

public class SchedulerPoolsArtifactConfigFactory
extends AbstractComponent
implements SchedulerPoolsConfigFactory {
    private final String threadNamePrefix;
    private final long gracefulShutdownTimeout;
    private final SchedulerPoolStrategy poolStrategy;
    private final IoPoolConfig uberPoolConfig;
    private final CpuLightPoolConfig cpuLightPoolConfig;
    private final IoPoolConfig ioPoolConfig;
    private final CpuIntensivePoolConfig cpuIntensivePoolConfig;

    public SchedulerPoolsArtifactConfigFactory(String threadNamePrefix, long gracefulShutdownTimeout, SchedulerPoolStrategy poolStrategy, IoPoolConfig uberPoolConfig, CpuLightPoolConfig cpuLightPoolConfig, IoPoolConfig ioPoolConfig, CpuIntensivePoolConfig cpuIntensivePoolConfig) {
        this.threadNamePrefix = threadNamePrefix;
        this.gracefulShutdownTimeout = gracefulShutdownTimeout;
        this.poolStrategy = poolStrategy;
        this.uberPoolConfig = uberPoolConfig;
        this.cpuLightPoolConfig = cpuLightPoolConfig;
        this.ioPoolConfig = ioPoolConfig;
        this.cpuIntensivePoolConfig = cpuIntensivePoolConfig;
    }

    @Override
    public Optional<SchedulerPoolsConfig> getConfig() {
        return Optional.of(new SchedulerPoolsArtifactConfig(this.threadNamePrefix, this.gracefulShutdownTimeout, this.poolStrategy, this.uberPoolConfig, this.cpuLightPoolConfig, this.ioPoolConfig, this.cpuIntensivePoolConfig));
    }

    public static class CpuIntensivePoolConfig {
        private int poolSize;
        private int queueSize;

        public int getPoolSize() {
            return this.poolSize;
        }

        public void setPoolSize(int poolSize) {
            this.poolSize = poolSize;
        }

        public int getQueueSize() {
            return this.queueSize;
        }

        public void setQueueSize(int queueSize) {
            this.queueSize = queueSize;
        }
    }

    public static class IoPoolConfig {
        private int corePoolSize;
        private int maxPoolSize;
        private int queueSize;
        private long keepAlive;

        public int getCorePoolSize() {
            return this.corePoolSize;
        }

        public void setCorePoolSize(int corePoolSize) {
            this.corePoolSize = corePoolSize;
        }

        public int getMaxPoolSize() {
            return this.maxPoolSize;
        }

        public void setMaxPoolSize(int maxPoolSize) {
            this.maxPoolSize = maxPoolSize;
        }

        public int getQueueSize() {
            return this.queueSize;
        }

        public void setQueueSize(int queueSize) {
            this.queueSize = queueSize;
        }

        public long getKeepAlive() {
            return this.keepAlive;
        }

        public void setKeepAlive(long keepAlive) {
            this.keepAlive = keepAlive;
        }
    }

    public static class CpuLightPoolConfig {
        private int poolSize;
        private int queueSize;

        public int getPoolSize() {
            return this.poolSize;
        }

        public void setPoolSize(int poolSize) {
            this.poolSize = poolSize;
        }

        public int getQueueSize() {
            return this.queueSize;
        }

        public void setQueueSize(int queueSize) {
            this.queueSize = queueSize;
        }
    }
}

