/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.core.internal.processor;

import com.mulesoft.mule.runtime.core.internal.processor.MessageTransformation;
import com.mulesoft.mule.runtime.core.internal.processor.TransformationTarget;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import org.mule.api.annotation.NoInstantiate;
import org.mule.runtime.api.component.AbstractComponent;
import org.mule.runtime.api.el.BindingContextUtils;
import org.mule.runtime.api.el.ExpressionCompilationException;
import org.mule.runtime.api.el.ExpressionLanguage;
import org.mule.runtime.api.event.EventContext;
import org.mule.runtime.api.exception.DefaultMuleException;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.core.api.el.ExpressionManager;
import org.mule.runtime.core.api.el.ExpressionManagerSession;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.expression.InvalidExpressionException;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.processor.ReactiveProcessor;
import org.mule.runtime.core.internal.event.EventUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NoInstantiate
public final class TransformMessageProcessor
extends AbstractComponent
implements Processor,
Startable {
    private static final Logger LOGGER = LoggerFactory.getLogger(TransformMessageProcessor.class);
    @Inject
    private ExpressionManager expressionManager;
    @Inject
    private ExpressionLanguage expressionLanguage;
    private MessageTransformation messageTransformation;
    private List<TransformationTarget> variables;

    public void setMessageTransformation(MessageTransformation messageTransformation) {
        this.messageTransformation = messageTransformation;
    }

    public void setVariables(List<TransformationTarget> variables) {
        this.variables = variables;
    }

    @Override
    public ReactiveProcessor.ProcessingType getProcessingType() {
        String processingType = System.getProperty("mule.dwScript.processingType");
        if (processingType != null) {
            try {
                return ReactiveProcessor.ProcessingType.valueOf(processingType);
            }
            catch (IllegalArgumentException e) {
                LOGGER.error("Invalid value for system property mule.dwScript.processingType: " + processingType);
                return ReactiveProcessor.ProcessingType.CPU_INTENSIVE;
            }
        }
        return ReactiveProcessor.ProcessingType.CPU_INTENSIVE;
    }

    @Override
    public CoreEvent process(CoreEvent event) throws MuleException {
        CoreEvent.Builder eventBuilder = CoreEvent.builder(event);
        EventContext eventContext = EventUtils.getRoot(event.getContext());
        try (ExpressionManagerSession emSession = this.expressionManager.openSession(this.getLocation(), event, BindingContextUtils.NULL_BINDING_CONTEXT);){
            if (this.messageTransformation != null) {
                Message.Builder messageBuilder = Message.builder(event.getMessage());
                this.messageTransformation.getPayloadTransformation().ifPresent(target -> target.process(eventBuilder, messageBuilder, emSession, eventContext));
                this.messageTransformation.getAttributesTransformation().ifPresent(target -> target.process(eventBuilder, messageBuilder, emSession, eventContext));
                eventBuilder.message(messageBuilder.build());
            }
            if (this.variables != null) {
                for (TransformationTarget target2 : this.variables) {
                    target2.process(eventBuilder, null, emSession, eventContext);
                }
            }
            CoreEvent coreEvent = eventBuilder.build();
            return coreEvent;
        }
    }

    @Override
    public void start() throws MuleException {
        if (this.messageTransformation != null) {
            Optional<TransformationTarget> attributesTransformation;
            Optional<TransformationTarget> payloadTransformation = this.messageTransformation.getPayloadTransformation();
            if (payloadTransformation.isPresent()) {
                this.initTransformation(payloadTransformation.get());
            }
            if ((attributesTransformation = this.messageTransformation.getAttributesTransformation()).isPresent()) {
                this.initTransformation(attributesTransformation.get());
            }
        }
        if (this.variables != null) {
            for (TransformationTarget target : this.variables) {
                this.initTransformation(target);
            }
        }
    }

    private void initTransformation(TransformationTarget transformationTarget) throws MuleException {
        try {
            transformationTarget.initialize(this.expressionLanguage);
        }
        catch (ExpressionCompilationException e) {
            throw new DefaultMuleException(new InvalidExpressionException(transformationTarget.getExpression(), e.getMessage()));
        }
    }
}

