/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.module.batch;

import com.mulesoft.mule.runtime.module.batch.BatchProperties;
import com.mulesoft.mule.runtime.module.batch.engine.BatchJobAdapter;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.event.EventContext;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.streaming.CursorProvider;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.event.EventContextFactory;
import org.mule.runtime.core.privileged.event.PrivilegedEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchEvent {
    private static final Logger LOGGER = LoggerFactory.getLogger(BatchEvent.class);
    private final String correlationId;
    private final Map<String, TypedValue<?>> variables;
    private final ComponentLocation componentLocation;
    private final Optional<Map<String, String>> loggingVariables;

    public static BatchEvent of(CoreEvent event) {
        Optional<Map<String, String>> loggingVariables = Optional.empty();
        if (event instanceof PrivilegedEvent) {
            loggingVariables = ((PrivilegedEvent)event).getLoggingVariables();
        }
        return new BatchEvent(event.getCorrelationId(), BatchEvent.extractVariables(event), event.getContext().getOriginatingLocation(), loggingVariables);
    }

    protected static Map<String, TypedValue<?>> extractVariables(CoreEvent event) {
        return event.getVariables().entrySet().stream().filter(entry -> !BatchProperties.ALL_INTERNAL_VARS.contains(entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, entry -> {
            TypedValue value = (TypedValue)entry.getValue();
            if (value.getValue() instanceof CursorProvider && LOGGER.isWarnEnabled()) {
                LOGGER.warn("Batch job is being created with variable {} which is a streaming value. Streaming values are potentially large, and thus should not be part of a batch variable but a batch record. This is bad practice that will threaten the stability and performance of the application.", entry.getKey());
            }
            return value;
        }));
    }

    public BatchEvent(String correlationId, Map<String, TypedValue<?>> variables, ComponentLocation componentLocation) {
        this(correlationId, variables, componentLocation, Optional.empty());
    }

    public BatchEvent(String correlationId, Map<String, TypedValue<?>> variables, ComponentLocation componentLocation, Optional<Map<String, String>> loggingVariables) {
        this.correlationId = correlationId;
        this.variables = variables;
        this.componentLocation = componentLocation;
        this.loggingVariables = loggingVariables;
    }

    @Deprecated
    public CoreEvent.Builder asEventBuilder(BatchJobAdapter batchJob) {
        return this.asEventBuilder(batchJob, null);
    }

    public CoreEvent.Builder asEventBuilder(BatchJobAdapter batchJob, CompletableFuture<Void> externalCompletion) {
        CoreEvent.Builder eventBuilder;
        EventContext context = EventContextFactory.create(batchJob.getMuleContext().getUniqueIdString(), batchJob.getMuleContext().getId(), this.componentLocation, this.correlationId, Optional.ofNullable(externalCompletion));
        if (this.loggingVariables.isPresent()) {
            PrivilegedEvent.Builder builder = PrivilegedEvent.builder(context);
            this.loggingVariables.get().forEach((key, value) -> builder.addLoggingVariable((String)key, (String)value));
            eventBuilder = builder;
        } else {
            eventBuilder = CoreEvent.builder(context);
        }
        this.variables.forEach(eventBuilder::addVariable);
        return eventBuilder;
    }

    public String getCorrelationId() {
        return this.correlationId;
    }

    public Map<String, TypedValue<?>> getVariables() {
        return this.variables;
    }

    public ComponentLocation getComponentLocation() {
        return this.componentLocation;
    }

    public Optional<Map<String, String>> getLoggingVariables() {
        return this.loggingVariables;
    }
}

