/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.module.batch.api.record;

import com.mulesoft.mule.runtime.module.batch.BatchProperties;
import com.mulesoft.mule.runtime.module.batch.api.BatchStep;
import com.mulesoft.mule.runtime.module.batch.api.extension.record.RecordWithErrors;
import com.mulesoft.mule.runtime.module.batch.api.record.RecordCompletionTracker;
import com.mulesoft.mule.runtime.module.batch.api.record.RecordELAdapter;
import com.mulesoft.mule.runtime.module.batch.internal.engine.RecordCompletableFuture;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.mule.api.annotation.NoExtend;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.core.api.event.CoreEvent;

@NoExtend
public class Record
implements Serializable,
RecordWithErrors {
    private static final long serialVersionUID = 344076031373316391L;
    private TypedValue<Object> payload;
    private TypedValue<Object> attributes;
    private final Map<String, TypedValue<?>> variables = new ConcurrentHashMap();
    private final Map<String, Exception> stepExceptions = new HashMap<String, Exception>();
    private final Set<String> processedSteps = new LinkedHashSet<String>();
    private String currentStepId;
    private transient RecordCompletionTracker completionCallback = new RecordCompletableFuture();

    public Record(TypedValue<Object> payload) {
        this(payload, null);
    }

    public Record(TypedValue<Object> payload, TypedValue<Object> attributes) {
        this.payload = payload;
        this.attributes = attributes;
    }

    public TypedValue<Object> getPayload() {
        return this.payload;
    }

    public TypedValue<Object> getAttributes() {
        return this.attributes;
    }

    public void setPayload(TypedValue<Object> payload) {
        this.setPayload(payload, null);
    }

    public void setPayload(TypedValue<Object> payload, TypedValue<Object> attributes) {
        this.payload = payload;
        this.attributes = attributes;
    }

    public <T> TypedValue<T> getVariable(String key) {
        return this.variables.get(key);
    }

    public Object removeVariable(String key) {
        return this.variables.remove(key);
    }

    public Map<String, TypedValue<?>> getAllVariables() {
        return Collections.unmodifiableMap(this.variables);
    }

    public void updateWith(CoreEvent event) {
        Message message = event.getMessage();
        this.setPayload(message.getPayload(), message.getAttributes());
        this.replaceVariables(event.getVariables());
    }

    public void updateWith(RecordELAdapter adapter) {
        HashMap updatedVars = new HashMap();
        adapter.getVars().forEach((k, v) -> {
            TypedValue<Object> current = this.variables.get(k);
            if (current == null || current.getValue() != v) {
                TypedValue<Object> typedValue = current = v != null ? TypedValue.of(v) : null;
            }
            if (current != null) {
                updatedVars.put((String)k, current);
            }
        });
        this.replaceVariables(updatedVars);
    }

    public void replaceVariables(Map<String, TypedValue<?>> newVariables) {
        this.variables.clear();
        newVariables.forEach((k, v) -> {
            if (!BatchProperties.ALL_INTERNAL_VARS.contains(k)) {
                this.variables.put((String)k, (TypedValue<?>)v);
            }
        });
        this.variables.putAll(newVariables);
    }

    public Record markAsFailedInStep(BatchStep step, Exception e) {
        this.stepExceptions.put(step != null ? step.getName() : this.currentStepId, e);
        return this;
    }

    public Record markAsProcessedByStep(BatchStep step) {
        this.processedSteps.add(step.getName());
        return this;
    }

    public int getFailedStepsCount() {
        return this.stepExceptions.size();
    }

    public Exception getExceptionForStep(String stepName) {
        return this.stepExceptions.get(stepName);
    }

    public Map<String, Exception> getStepExceptions() {
        return Collections.unmodifiableMap(new HashMap<String, Exception>(this.stepExceptions));
    }

    public Exception getFirstException() {
        return this.processedSteps.stream().map(this::getExceptionForStep).filter(Objects::nonNull).findFirst().orElse(null);
    }

    public Exception getLastException() {
        return this.processedSteps.stream().map(this::getExceptionForStep).filter(Objects::nonNull).reduce((first, second) -> second).orElse(null);
    }

    public TypedValue<?> addVariable(String key, TypedValue<?> value) {
        if (value == null || value.getValue() == null) {
            return this.variables.remove(key);
        }
        return this.variables.put(key, value);
    }

    @Override
    public boolean hasErrors() {
        return !this.stepExceptions.isEmpty();
    }

    public boolean isFailedFor(BatchStep step) {
        return this.stepExceptions.get(step.getName()) != null;
    }

    public String getCurrentStepId() {
        return this.currentStepId;
    }

    public void setCurrentStepId(String currentStepId) {
        this.currentStepId = currentStepId;
    }

    public RecordCompletionTracker getCompletionCallback() {
        return this.completionCallback;
    }

    public void setCompletionCallback(RecordCompletionTracker completionCallback) {
        this.completionCallback = completionCallback;
    }
}

