/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.module.batch.internal.engine;

import com.mulesoft.mule.runtime.module.batch.api.extension.structure.BatchJobInstance;
import com.mulesoft.mule.runtime.module.batch.engine.BatchJobInstanceAdapter;
import com.mulesoft.mule.runtime.module.batch.exception.BatchException;
import com.mulesoft.mule.runtime.module.batch.internal.exception.BatchFailureHandlingException;
import java.io.ByteArrayOutputStream;
import java.util.Optional;
import java.util.function.Function;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.exception.DefaultMuleException;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.message.Error;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.notification.EnrichedNotificationInfo;
import org.mule.runtime.core.api.context.notification.FlowTraceManager;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.message.OutputHandler;
import org.mule.runtime.core.api.processor.ReactiveProcessor;
import org.mule.runtime.core.api.util.StreamCloserService;
import org.mule.runtime.core.internal.util.rx.ReactorTransactionUtils;
import org.mule.runtime.core.privileged.event.BaseEventContext;
import org.mule.runtime.core.privileged.exception.MessagingException;
import org.mule.runtime.core.privileged.processor.MessageProcessors;
import org.mule.runtime.tracer.api.EventTracer;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public abstract class BatchProcessingTemplate {
    private final ReactiveProcessor messageProcessor = pub -> Mono.from((Publisher)pub).contextWrite(ReactorTransactionUtils.popTxFromSubscriberContext()).transform((Function)processor).contextWrite(ReactorTransactionUtils.pushTxToSubscriberContext(location.getLocation()));
    private final StreamCloserService closer;
    private final FlowTraceManager flowTraceManager;

    public BatchProcessingTemplate(ReactiveProcessor processor, ComponentLocation location, FlowTraceManager flowTraceManager, StreamCloserService streamCloser) {
        this.flowTraceManager = flowTraceManager;
        this.closer = streamCloser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CoreEvent process(BatchJobInstanceAdapter jobInstance, CoreEvent event, EventTracer<CoreEvent> coreEventTracer) throws MuleException {
        CoreEvent resultEvent;
        block12: {
            CoreEvent.Builder builder = CoreEvent.builder(event);
            resultEvent = null;
            try {
                this.before(jobInstance, event);
                try {
                    resultEvent = MessageProcessors.processToApply(event, this.messageProcessor);
                }
                catch (MessagingException me) {
                    resultEvent = me.getEvent();
                    builder = CoreEvent.builder(resultEvent);
                    throw me;
                }
                if (resultEvent == null) {
                    resultEvent = event;
                }
                builder = CoreEvent.builder(resultEvent);
                Optional<Error> errorOptional = resultEvent.getError();
                if (errorOptional.isPresent()) {
                    Throwable t = errorOptional.get().getCause();
                    Exception e = t instanceof Exception ? (Exception)t : new BatchException(t, (BatchJobInstance)jobInstance);
                    this.handleException(jobInstance, e, event);
                    break block12;
                }
                this.handleSuccess(jobInstance, resultEvent, builder);
            }
            catch (Exception e) {
                try {
                    if (e.getCause() instanceof InterruptedException) {
                        throw new DefaultMuleException(e.getCause());
                    }
                    this.handleException(jobInstance, e, builder.build());
                }
                catch (Throwable throwable) {
                    this.onFinally(jobInstance, event, resultEvent);
                    if (resultEvent != null) {
                        ((BaseEventContext)resultEvent.getContext()).success();
                    }
                    coreEventTracer.endCurrentSpan(event);
                    throw throwable;
                }
                this.onFinally(jobInstance, event, resultEvent);
                if (resultEvent != null) {
                    ((BaseEventContext)resultEvent.getContext()).success();
                }
                coreEventTracer.endCurrentSpan(event);
            }
        }
        this.onFinally(jobInstance, event, resultEvent);
        if (resultEvent != null) {
            ((BaseEventContext)resultEvent.getContext()).success();
        }
        coreEventTracer.endCurrentSpan(event);
        return resultEvent;
    }

    protected void handleSuccess(BatchJobInstanceAdapter jobInstance, CoreEvent resultEvent, CoreEvent.Builder builder) throws Exception {
        this.resolveOutputHandlerPayload(resultEvent, builder);
        this.onSuccess(jobInstance, builder.build());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleException(BatchJobInstanceAdapter jobInstance, Exception e, CoreEvent event) throws MuleException {
        Exception toHandle = e;
        CoreEvent.Builder builder = CoreEvent.builder(event);
        try {
            this.resolveOutputHandlerPayload(event, builder);
        }
        catch (Exception innerException) {
            toHandle = new BatchFailureHandlingException(e, (Throwable)innerException, (BatchJobInstance)jobInstance);
        }
        finally {
            this.onException(jobInstance, toHandle, builder.build());
        }
    }

    protected void resolveOutputHandlerPayload(CoreEvent event, CoreEvent.Builder builder) throws Exception {
        Message message = event.getMessage();
        if (message.getPayload().getValue() instanceof OutputHandler) {
            try {
                ByteArrayOutputStream payloadOutputStream = new ByteArrayOutputStream();
                ((OutputHandler)message.getPayload().getValue()).write(event, payloadOutputStream);
                builder.message(Message.builder(message).value(payloadOutputStream.toByteArray()).build());
            }
            catch (Exception e) {
                builder.message(Message.builder(message).nullValue().build());
                throw e;
            }
        }
    }

    protected void before(BatchJobInstanceAdapter jobInstance, CoreEvent event) throws MuleException {
        this.flowTraceManager.onFlowStart(EnrichedNotificationInfo.createInfo(event, null, null), String.format("%s [jobId: %s]", jobInstance.getOwnerJobName(), jobInstance.getId()));
    }

    protected void onFinally(BatchJobInstanceAdapter jobInstance, CoreEvent originalEvent, CoreEvent resultEvent) throws MuleException {
        if (resultEvent != null) {
            this.closer.closeStream(resultEvent.getMessage().getPayload().getValue());
        }
        this.flowTraceManager.onFlowComplete(EnrichedNotificationInfo.createInfo(resultEvent != null ? resultEvent : originalEvent, null, null));
    }

    protected abstract void onException(BatchJobInstanceAdapter var1, Exception var2, CoreEvent var3) throws MuleException;

    protected abstract void onSuccess(BatchJobInstanceAdapter var1, CoreEvent var2) throws MuleException;
}

