/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.module.batch.internal.engine;

import com.mulesoft.mule.runtime.module.batch.internal.kryo.BatchEventSerializer;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.function.Supplier;
import org.mule.runtime.api.serialization.ObjectSerializer;
import org.mule.runtime.api.serialization.SerializationException;
import org.mule.runtime.api.serialization.SerializationProtocol;

public class LegacyAwareObjectSerializerWrapper
implements ObjectSerializer {
    private final SerializationProtocol internalProtocol;
    private final SerializationProtocol externalProtocol;

    public LegacyAwareObjectSerializerWrapper(ObjectSerializer serializer) {
        this.internalProtocol = new SerializationProtocolWrapper(serializer.getInternalProtocol());
        this.externalProtocol = new SerializationProtocolWrapper(serializer.getExternalProtocol());
    }

    @Override
    public SerializationProtocol getInternalProtocol() {
        return this.internalProtocol;
    }

    @Override
    public SerializationProtocol getExternalProtocol() {
        return this.externalProtocol;
    }

    private static class SerializationProtocolWrapper
    implements SerializationProtocol {
        private final SerializationProtocol protocol;

        public SerializationProtocolWrapper(SerializationProtocol protocol) {
            this.protocol = protocol;
        }

        @Override
        public byte[] serialize(Object o) throws SerializationException {
            return this.protocol.serialize(o);
        }

        @Override
        public void serialize(Object o, OutputStream outputStream) throws SerializationException {
            this.protocol.serialize(o, outputStream);
        }

        @Override
        public <T> T deserialize(byte[] bytes) throws SerializationException {
            try {
                return this.protocol.deserialize(bytes);
            }
            catch (SerializationException e) {
                return (T)this.executeIndicatingLegacySerialization(e, () -> this.protocol.deserialize(bytes));
            }
        }

        @Override
        public <T> T deserialize(byte[] bytes, ClassLoader classLoader) throws SerializationException {
            try {
                return this.protocol.deserialize(bytes, classLoader);
            }
            catch (SerializationException e) {
                return (T)this.executeIndicatingLegacySerialization(e, () -> this.protocol.deserialize(bytes, classLoader));
            }
        }

        @Override
        public <T> T deserialize(InputStream inputStream) throws SerializationException {
            return this.protocol.deserialize(inputStream);
        }

        @Override
        public <T> T deserialize(InputStream inputStream, ClassLoader classLoader) throws SerializationException {
            return this.protocol.deserialize(inputStream, classLoader);
        }

        private <T> T executeIndicatingLegacySerialization(SerializationException originalException, Supplier<T> supplier) {
            BatchEventSerializer.setLegacyBatchEventSerializer();
            try {
                T t = supplier.get();
                return t;
            }
            catch (Throwable ex) {
                throw originalException;
            }
            finally {
                BatchEventSerializer.unsetLegacyBatchEventSerializer();
            }
        }
    }
}

