/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.module.batch.internal.engine.transaction;

import com.mulesoft.mule.runtime.module.batch.engine.BatchEngine;
import com.mulesoft.mule.runtime.module.batch.engine.BatchJobInstanceAdapter;
import com.mulesoft.mule.runtime.module.batch.engine.transaction.BatchTransactionContext;
import com.mulesoft.mule.runtime.module.batch.engine.transaction.BatchTransactionContextFactory;
import com.mulesoft.mule.runtime.module.batch.internal.engine.transaction.BaseBatchTransactionContextWrapper;
import com.mulesoft.mule.runtime.module.batch.internal.engine.transaction.DefaultBatchTransactionContext;
import com.mulesoft.mule.runtime.module.batch.util.BatchUtils;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.transaction.xa.ResourceManagerException;

public class DefaultBatchTransactionContextFactory
implements BatchTransactionContextFactory {
    private final Set<BatchTransactionContext> contexts = Collections.newSetFromMap(new ConcurrentHashMap());
    private final BatchEngine batchEngine;
    private final AtomicBoolean closing = new AtomicBoolean(false);

    public DefaultBatchTransactionContextFactory(BatchEngine batchEngine) {
        this.batchEngine = batchEngine;
    }

    public int getTrackedContextsCount() {
        return this.contexts.size();
    }

    @Override
    public BatchTransactionContext createTransactionContext(BatchJobInstanceAdapter jobInstance) {
        this.checkNotClosed();
        DefaultBatchTransactionContext ctx = new DefaultBatchTransactionContext(this.batchEngine.getJobFor(jobInstance), jobInstance, this.batchEngine.getBatchQueueManager().newQueueSession());
        return new ManagedBatchTransactionContext(ctx);
    }

    @Override
    public void closeAndRollback() {
        if (this.closing.compareAndSet(false, true)) {
            for (BatchTransactionContext ctx : this.contexts) {
                BatchUtils.rollback(ctx);
            }
            this.contexts.clear();
        }
    }

    @Override
    public int countOpenTransactions() {
        return this.contexts.size();
    }

    private void checkNotClosed() {
        Preconditions.checkState(!this.closing.get(), "Can't create new contexts after factory is closed");
    }

    private class ManagedBatchTransactionContext
    extends BaseBatchTransactionContextWrapper {
        private ManagedBatchTransactionContext(BatchTransactionContext wrapped) {
            super(wrapped);
        }

        @Override
        public void beginTransaction() throws ResourceManagerException {
            DefaultBatchTransactionContextFactory.this.checkNotClosed();
            this.delegate.beginTransaction();
            DefaultBatchTransactionContextFactory.this.contexts.add(this.delegate);
        }

        @Override
        public void commit() throws ResourceManagerException {
            try {
                this.delegate.commit();
            }
            finally {
                DefaultBatchTransactionContextFactory.this.contexts.remove(this.delegate);
            }
        }

        @Override
        public void rollback() throws ResourceManagerException {
            try {
                this.delegate.rollback();
            }
            finally {
                DefaultBatchTransactionContextFactory.this.contexts.remove(this.delegate);
            }
        }
    }
}

