/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.module.batch.reporting;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.mulesoft.mule.runtime.module.batch.api.BatchStep;
import com.mulesoft.mule.runtime.module.batch.api.extension.structure.BatchJobInstance;
import com.mulesoft.mule.runtime.module.batch.engine.BatchJobInstanceAdapter;
import com.mulesoft.mule.runtime.module.batch.exception.BatchException;
import com.mulesoft.mule.runtime.module.batch.exception.ExceptionHistory;
import com.mulesoft.mule.runtime.module.batch.util.BatchUtils;
import org.mule.runtime.api.exception.ExceptionHelper;
import org.slf4j.Logger;

public class StepExceptionReporter {
    private final BatchStep step;
    private final Logger logger;
    private final LoadingCache<BatchJobInstance, ExceptionHistory> histories = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<BatchJobInstance, ExceptionHistory>(){

        public ExceptionHistory load(BatchJobInstance key) throws Exception {
            return new ExceptionHistory();
        }
    });

    public StepExceptionReporter(BatchStep step, Logger logger) {
        this.step = step;
        this.logger = logger;
    }

    public void report(BatchJobInstanceAdapter jobInstance, Exception exception) {
        ExceptionHistory history = (ExceptionHistory)this.histories.getUnchecked((Object)jobInstance);
        if (history.add(this.extract(jobInstance, exception)) && this.logger.isInfoEnabled()) {
            this.logger.info(BatchUtils.buildExceptionLogMessage(jobInstance, this.step, exception));
        }
    }

    public void reset(BatchJobInstanceAdapter jobInstance) {
        this.histories.invalidate((Object)jobInstance);
    }

    public ExceptionHistory getExceptionHistory(BatchJobInstanceAdapter jobInstance) {
        return (ExceptionHistory)this.histories.asMap().get(jobInstance);
    }

    private Exception extract(BatchJobInstanceAdapter jobInstance, Exception exception) {
        Exception e = ExceptionHelper.getRootMuleException(exception);
        if (e == null) {
            Throwable t = ExceptionHelper.getRootException(exception);
            e = t instanceof Exception ? (Exception)t : new BatchException(t, (BatchJobInstance)jobInstance);
        }
        return e;
    }
}

