/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.module.cluster.internal;

import com.hazelcast.core.HazelcastException;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.map.IMap;
import com.hazelcast.splitbrainprotection.SplitBrainProtectionException;
import com.mulesoft.mule.runtime.module.cluster.api.exception.ClusterQuorumException;
import com.mulesoft.mule.runtime.module.cluster.api.exception.ClusterRuntimeException;
import com.mulesoft.mule.runtime.module.cluster.internal.HazelcastClusterManager;
import com.mulesoft.mule.runtime.module.cluster.internal.persistence.MapNameNormalizer;
import com.mulesoft.mule.runtime.module.cluster.internal.serialization.ClusterDistributedObject;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.store.ObjectAlreadyExistsException;
import org.mule.runtime.api.store.ObjectDoesNotExistException;
import org.mule.runtime.api.store.ObjectStoreException;
import org.mule.runtime.api.store.ObjectStoreNotAvailableException;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.i18n.CoreMessages;
import org.mule.runtime.core.api.context.MuleContextAware;
import org.mule.runtime.core.internal.store.AbstractPartitionableObjectStore;

public class HazelcastObjectStore<T extends Serializable>
extends AbstractPartitionableObjectStore<T>
implements MuleContextAware,
Disposable {
    public static final String DEFAULT_PARTITION_NAME = "default";
    public static final String ALL_PARTITIONS_MAP_NAME = "_all_partitions";
    public static final String PARTITION_MAP_NAME = "_partition_";
    protected MuleContext muleContext;
    protected HazelcastInstance instance;
    protected String appName;
    protected boolean running;
    private IMap<String, T> map;
    private IMap<String, Object> partitionNameToDistributedMapName;
    @Inject
    @Named(value="_muleClusterManager")
    private HazelcastClusterManager hazelcastManager;

    public HazelcastObjectStore(HazelcastInstance instance) {
        System.setProperty("hazelcast.logging.type", "slf4j");
        this.instance = instance;
        this.running = true;
    }

    public static String getObjectStorePrefix(String appName) {
        return MapNameNormalizer.normalize(appName) + PARTITION_MAP_NAME;
    }

    @Override
    @Inject
    public void setMuleContext(MuleContext muleContext) {
        if (this.appName == null) {
            this.muleContext = muleContext;
            this.appName = MapNameNormalizer.normalize(muleContext.getConfiguration().getId());
            String mapName = MapNameNormalizer.normalize(this.appName) + DEFAULT_PARTITION_NAME;
            this.map = this.instance.getMap(mapName);
            this.partitionNameToDistributedMapName = this.instance.getMap(this.appName + ALL_PARTITIONS_MAP_NAME);
        }
    }

    @Override
    public void open() throws ObjectStoreException {
    }

    @Override
    public void close() throws ObjectStoreException {
        this.running = false;
    }

    @Override
    public List<String> allKeys() throws ObjectStoreException {
        if (!this.running) {
            return Collections.emptyList();
        }
        try {
            return this.doAllKeys(this.map);
        }
        catch (SplitBrainProtectionException qe) {
            throw new ClusterQuorumException("Error on allKeys", (Throwable)qe);
        }
        catch (HazelcastException he) {
            throw new ClusterRuntimeException("Error on allKeys", (Throwable)he);
        }
    }

    @Override
    public Map<String, T> retrieveAll() throws ObjectStoreException {
        if (!this.running) {
            return Collections.emptyMap();
        }
        try {
            return this.doRetrieveAll(this.map);
        }
        catch (SplitBrainProtectionException qe) {
            throw new ClusterQuorumException("Error on retrieveAll", (Throwable)qe);
        }
        catch (HazelcastException he) {
            throw new ClusterRuntimeException("Error on retrieveAll", (Throwable)he);
        }
    }

    private List<String> doAllKeys(IMap theMap) {
        return new ArrayList<String>(theMap.keySet());
    }

    private Map<String, T> doRetrieveAll(IMap<String, T> theMap) {
        return theMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> this.deserialize((Serializable)entry.getValue()), (u, v) -> {
            throw new IllegalStateException(String.format("Duplicate key %s", u));
        }, LinkedHashMap::new));
    }

    @Override
    public boolean contains(String key) throws ObjectStoreException {
        try {
            return this.doContains(this.map, (Serializable)((Object)key));
        }
        catch (SplitBrainProtectionException qe) {
            throw new ClusterQuorumException("Error on contains", (Throwable)qe);
        }
        catch (HazelcastException he) {
            throw new ClusterRuntimeException("Error on contains", (Throwable)he);
        }
    }

    @Override
    public void clear() throws ObjectStoreException {
        try {
            this.doClear(this.map);
        }
        catch (SplitBrainProtectionException qe) {
            throw new ClusterQuorumException("Error on clear", (Throwable)qe);
        }
        catch (HazelcastException he) {
            throw new ClusterRuntimeException("Error on clear", (Throwable)he);
        }
    }

    private boolean doContains(IMap<String, T> theMap, Serializable key) {
        if (!this.running) {
            return false;
        }
        return theMap.containsKey((Object)key);
    }

    @Override
    public void store(String key, T value) throws ObjectStoreException {
        this.checkRunning();
        try {
            this.doStore(this.map, key, value);
        }
        catch (SplitBrainProtectionException qe) {
            throw new ClusterQuorumException("Error on store", (Throwable)qe);
        }
        catch (HazelcastException he) {
            throw new ClusterRuntimeException("Error on store", (Throwable)he);
        }
    }

    private void doStore(IMap<String, T> theMap, String key, T value) throws ObjectStoreException {
        ClusterDistributedObject<T> distributedObject;
        this.checkRunning();
        try {
            distributedObject = ClusterDistributedObject.createSerializedForValue(value, this.muleContext.getObjectSerializer().getInternalProtocol());
        }
        catch (Exception se) {
            throw new ObjectStoreException(se);
        }
        if (theMap.putIfAbsent((Object)key, distributedObject) != null) {
            throw new ObjectAlreadyExistsException(CoreMessages.objectAlreadyExists(key));
        }
    }

    @Override
    public T retrieve(String key) throws ObjectStoreException {
        if (!this.running) {
            return null;
        }
        try {
            return this.doRetrieve(this.map, (Serializable)((Object)key));
        }
        catch (SplitBrainProtectionException qe) {
            throw new ClusterQuorumException("Error on retrieve", (Throwable)qe);
        }
        catch (HazelcastException he) {
            throw new ClusterRuntimeException("Error on retrieve", (Throwable)he);
        }
    }

    private T doRetrieve(IMap<String, T> theMap, Serializable key) throws ObjectDoesNotExistException {
        if (!this.running) {
            return null;
        }
        Serializable value = (Serializable)theMap.get((Object)key);
        if (value == null) {
            throw new ObjectDoesNotExistException(CoreMessages.objectNotFound(key));
        }
        return (T)this.deserialize(value);
    }

    private <E> E deserialize(E value) {
        if (value instanceof ClusterDistributedObject) {
            ClusterDistributedObject distributedObject = (ClusterDistributedObject)value;
            return (E)distributedObject.deserialize(this.muleContext.getObjectSerializer().getInternalProtocol()).getValue();
        }
        return value;
    }

    private void doClear(IMap<String, T> theMap) throws ObjectStoreException {
        this.checkRunning();
        theMap.clear();
    }

    @Override
    public T remove(String key) throws ObjectStoreException {
        this.checkRunning();
        try {
            return this.doRemove(this.map, (Serializable)((Object)key));
        }
        catch (SplitBrainProtectionException qe) {
            throw new ClusterQuorumException("Error on remove", (Throwable)qe);
        }
        catch (HazelcastException he) {
            throw new ClusterRuntimeException("Error on remove", (Throwable)he);
        }
    }

    private void checkRunning() throws ObjectStoreNotAvailableException {
        if (!this.running) {
            throw new ObjectStoreNotAvailableException();
        }
    }

    private T doRemove(IMap<String, T> theMap, Serializable key) throws ObjectStoreException {
        this.checkRunning();
        Serializable current = (Serializable)theMap.remove((Object)key);
        if (current == null) {
            throw new ObjectDoesNotExistException(CoreMessages.objectNotFound(key));
        }
        return (T)this.deserialize(current);
    }

    @Override
    public boolean isPersistent() {
        return false;
    }

    @Override
    public void open(String storeName) throws ObjectStoreException {
    }

    @Override
    protected boolean doContains(String key, String partitionName) throws ObjectStoreException {
        return this.doContains(this.getPartitionMap(partitionName), (Serializable)((Object)key));
    }

    @Override
    protected void doStore(String key, T value, String partitionName) throws ObjectStoreException {
        this.doStore(this.getPartitionMap(partitionName), key, value);
    }

    @Override
    protected T doRetrieve(String key, String partitionName) throws ObjectStoreException {
        return this.doRetrieve(this.getPartitionMap(partitionName), (Serializable)((Object)key));
    }

    @Override
    public void clear(String partitionName) throws ObjectStoreException {
        try {
            this.doClear(this.getPartitionMap(partitionName));
        }
        catch (SplitBrainProtectionException qe) {
            throw new ClusterQuorumException("Error on clear", (Throwable)qe);
        }
        catch (HazelcastException he) {
            throw new ClusterRuntimeException("Error on clear", (Throwable)he);
        }
    }

    @Override
    protected T doRemove(String key, String partitionName) throws ObjectStoreException {
        return this.doRemove(this.getPartitionMap(partitionName), (Serializable)((Object)key));
    }

    @Override
    public List<String> allKeys(String partitionName) throws ObjectStoreException {
        try {
            return this.doAllKeys(this.getPartitionMap(partitionName));
        }
        catch (SplitBrainProtectionException qe) {
            throw new ClusterQuorumException("Error on allKeys", (Throwable)qe);
        }
        catch (HazelcastException he) {
            throw new ClusterRuntimeException("Error on allKeys", (Throwable)he);
        }
    }

    @Override
    public Map<String, T> retrieveAll(String partitionName) throws ObjectStoreException {
        try {
            return this.doRetrieveAll(this.getPartitionMap(partitionName));
        }
        catch (SplitBrainProtectionException qe) {
            throw new ClusterQuorumException("Error on retrieveAll", (Throwable)qe);
        }
        catch (HazelcastException he) {
            throw new ClusterRuntimeException("Error on retrieveAll", (Throwable)he);
        }
    }

    @Override
    public List<String> allPartitions() throws ObjectStoreException {
        try {
            return new ArrayList<String>(this.partitionNameToDistributedMapName.keySet());
        }
        catch (SplitBrainProtectionException qe) {
            throw new ClusterQuorumException("Error on allPartitions", (Throwable)qe);
        }
        catch (HazelcastException he) {
            throw new ClusterRuntimeException("Error on allPartitions", (Throwable)he);
        }
    }

    @Override
    public void close(String partitionName) throws ObjectStoreException {
        try {
            this.partitionNameToDistributedMapName.remove((Object)partitionName);
        }
        catch (SplitBrainProtectionException qe) {
            throw new ClusterQuorumException("Error on close", (Throwable)qe);
        }
        catch (HazelcastException he) {
            throw new ClusterRuntimeException("Error on close", (Throwable)he);
        }
    }

    @Override
    public void disposePartition(String partitionName) throws ObjectStoreException {
        try {
            this.getPartitionMap(partitionName).destroy();
            this.partitionNameToDistributedMapName.remove((Object)partitionName);
        }
        catch (SplitBrainProtectionException qe) {
            throw new ClusterQuorumException("Error on disposePartition", (Throwable)qe);
        }
        catch (HazelcastException he) {
            throw new ClusterRuntimeException("Error on disposePartition", (Throwable)he);
        }
    }

    private synchronized IMap<String, T> getPartitionMap(String partitionName) {
        String encodedPartitionName = this.partitionMapKey(partitionName);
        if (!this.partitionNameToDistributedMapName.containsKey((Object)partitionName)) {
            ClusterDistributedObject<String> distributedObject = ClusterDistributedObject.forValue(encodedPartitionName, this.muleContext.getObjectSerializer().getInternalProtocol());
            this.partitionNameToDistributedMapName.put((Object)partitionName, distributedObject);
        }
        return this.instance.getMap(encodedPartitionName);
    }

    private String partitionMapKey(String partitionName) {
        return HazelcastObjectStore.getObjectStorePrefix(this.appName) + partitionName;
    }

    @Override
    public void dispose() {
        try {
            this.hazelcastManager.unregisterObjectStore(this);
        }
        catch (SplitBrainProtectionException qe) {
            throw new ClusterQuorumException("Error on dispose", (Throwable)qe);
        }
        catch (HazelcastException he) {
            throw new ClusterRuntimeException("Error on dispose", (Throwable)he);
        }
        try {
            this.close();
        }
        catch (ObjectStoreException e) {
            throw new MuleRuntimeException(e);
        }
    }
}

