/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.module.cluster.internal.boot;

import com.mulesoft.mule.runtime.module.cluster.internal.HazelcastClusterManager;
import com.mulesoft.mule.runtime.module.cluster.internal.boot.notification.MuleContextPrimaryClusterNodeListener;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.Lifecycle;
import org.mule.runtime.api.notification.NotificationDispatcher;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.internal.config.ClusterConfiguration;
import org.mule.runtime.core.internal.context.DefaultMuleContext;
import org.mule.runtime.core.privileged.registry.LegacyRegistryUtils;
import org.mule.runtime.core.privileged.registry.RegistrationException;

public class ClusterSupportAgent
implements Lifecycle {
    @Inject
    private MuleContext muleContext;
    @Inject
    private NotificationDispatcher notificationDispatcher;
    @Inject
    @Named(value="_muleClusterManager")
    private Optional<HazelcastClusterManager> hazelcastManager;
    private MuleContextPrimaryClusterNodeListener primaryClusterNodeListener;
    private boolean initialized = false;

    @Override
    public synchronized void initialise() throws InitialisationException {
        if (!this.initialized) {
            try {
                this.hazelcastManager.ifPresent(manager -> {
                    this.registerSpace((HazelcastClusterManager)manager);
                    ((DefaultMuleContext)this.muleContext).setSchedulerController(() -> manager.isPrimaryPollingInstance());
                    this.primaryClusterNodeListener = new MuleContextPrimaryClusterNodeListener(this.notificationDispatcher);
                    manager.registerPrimaryNodeListener(this.primaryClusterNodeListener);
                });
                this.initialized = true;
            }
            catch (Exception e) {
                throw new InitialisationException((Throwable)e, (Initialisable)this);
            }
        }
    }

    @Override
    public void start() throws MuleException {
    }

    @Override
    public void stop() throws MuleException {
    }

    protected void registerSpace(final HazelcastClusterManager manager) throws RegistrationException {
        LegacyRegistryUtils.registerObject(this.muleContext, "_mulePollingController", () -> manager.isPrimaryPollingInstance());
        LegacyRegistryUtils.registerObject(this.muleContext, "_muleClusterConfiguration", new ClusterConfiguration(){
            private String clusterId;
            private Integer clusterNodeId;

            @Override
            public String getClusterId() {
                if (this.clusterId == null) {
                    this.clusterId = manager.getClusterId();
                }
                return this.clusterId;
            }

            @Override
            public int getClusterNodeId() {
                if (this.clusterNodeId == null) {
                    this.clusterNodeId = Integer.valueOf(manager.getClusterNodeId());
                }
                return this.clusterNodeId;
            }
        });
    }

    @Override
    public synchronized void dispose() {
        this.hazelcastManager.ifPresent(manager -> manager.unregisterPrimaryNodeListener(this.primaryClusterNodeListener));
    }
}

