/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.module.cluster.internal.transaction;

import com.hazelcast.transaction.TransactionContext;
import org.mule.runtime.core.api.transaction.xa.ResourceManagerException;
import org.mule.runtime.core.internal.transaction.xa.AbstractTransactionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HazelcastTransactionContext
extends AbstractTransactionContext {
    private static final Logger logger = LoggerFactory.getLogger(HazelcastTransactionContext.class);
    private final TransactionContext transactionContext;
    private boolean transactionRollbacked;
    private boolean transactionCommited;

    HazelcastTransactionContext(TransactionContext transactionContext) {
        this.transactionContext = transactionContext;
        this.transactionContext.beginTransaction();
    }

    @Override
    public void doCommit() throws ResourceManagerException {
        try {
            if (!this.transactionCommited) {
                this.transactionCommited = true;
                this.transactionContext.commitTransaction();
            }
        }
        catch (Exception e) {
            block5: {
                try {
                    this.transactionRollbacked = true;
                    this.transactionContext.rollbackTransaction();
                }
                catch (Exception e2) {
                    logger.warn("failure during transaction rollback after commit failed: " + e.getMessage());
                    if (!logger.isDebugEnabled()) break block5;
                    logger.debug(e2.getMessage(), (Throwable)e2);
                }
            }
            throw new ResourceManagerException(e);
        }
    }

    @Override
    public void doRollback() throws ResourceManagerException {
        try {
            if (!this.transactionRollbacked) {
                this.transactionRollbacked = true;
                this.transactionContext.rollbackTransaction();
            }
        }
        catch (Exception e) {
            throw new ResourceManagerException(e);
        }
    }

    public TransactionContext getTransactionContext() {
        return this.transactionContext;
    }
}

