/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.module.cluster.internal.vm;

import com.hazelcast.collection.IQueue;
import com.hazelcast.config.QueueConfig;
import com.mulesoft.mule.runtime.module.cluster.internal.HazelcastClusterManager;
import com.mulesoft.mule.runtime.module.cluster.internal.vm.ClusterQueueNameResolver;
import com.mulesoft.mule.runtime.module.cluster.internal.vm.ClusterQueueSession;
import com.mulesoft.mule.runtime.module.cluster.internal.vm.ClusterQueueStore;
import javax.inject.Inject;
import org.apache.commons.lang3.NotImplementedException;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.util.queue.QueueConfiguration;
import org.mule.runtime.core.api.util.queue.QueueSession;
import org.mule.runtime.core.internal.util.queue.AbstractQueueManager;
import org.mule.runtime.core.internal.util.queue.QueueStore;
import org.mule.runtime.core.internal.util.queue.RecoverableQueueStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterQueueManager
extends AbstractQueueManager
implements ClusterQueueNameResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClusterQueueManager.class);
    public static final String QUEUE_LABEL = "-queue-";
    private final HazelcastClusterManager hazelcastManager;
    @Inject
    private MuleContext injectedMuleContext;

    public ClusterQueueManager(HazelcastClusterManager hazelcastManager) {
        this.hazelcastManager = hazelcastManager;
    }

    @Override
    public QueueSession getQueueSession() {
        return new ClusterQueueSession(this.hazelcastManager.getHazelcastInstance(), this, this, this.getMuleContext());
    }

    @Override
    public void start() throws MuleException {
    }

    @Override
    public void stop() throws MuleException {
    }

    @Override
    protected QueueStore createQueueStore(String queueName, QueueConfiguration config) {
        String encodedQueueName = this.resolveQueueName(queueName);
        if (!this.hazelcastManager.isClientModeEnabled()) {
            this.hazelcastManager.getHazelcastInstance().getConfig().getQueueConfig(encodedQueueName).setMaxSize(config.getCapacity());
        }
        return new ClusterQueueStore(queueName, config, (IQueue<Object>)this.hazelcastManager.getHazelcastInstance().getQueue(encodedQueueName), this.getMuleContext().getObjectSerializer());
    }

    @Override
    protected void doDispose() {
    }

    @Override
    public RecoverableQueueStore getRecoveryQueue(String queueName) {
        throw new NotImplementedException("Recovery queues are not available for cluster nor required");
    }

    @Override
    public void initialise() throws InitialisationException {
        this.setMuleContext(this.injectedMuleContext);
    }

    void configureQueueBackups(int numberOfBackups) {
        if (!this.hazelcastManager.isClientModeEnabled()) {
            QueueConfig queueConfig = this.hazelcastManager.getHazelcastInstance().getConfig().getQueueConfig(ClusterQueueManager.getQueuePrefix(this.getMuleContext()));
            queueConfig.setBackupCount(numberOfBackups);
        } else {
            LOGGER.debug("The client queue number of backups will be ignored. Server configuration will be honoured");
        }
    }

    @Override
    public String resolveQueueName(String queueName) {
        return ClusterQueueManager.resolveQueueName(this.hazelcastManager.getClusterId() + "_" + this.getMuleContext().getConfiguration().getId(), queueName);
    }

    public static String getQueuePrefix(MuleContext muleContext) {
        return ClusterQueueManager.getQueuePrefix(muleContext.getConfiguration().getId());
    }

    public static String getQueuePrefix(String appId) {
        return appId + QUEUE_LABEL;
    }

    public static String resolveQueueName(String appId, String queueName) {
        return ClusterQueueManager.getQueuePrefix(appId) + queueName;
    }
}

