/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.module.cluster.internal.vm;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.transaction.TransactionContext;
import com.hazelcast.transaction.TransactionOptions;
import com.mulesoft.mule.runtime.module.cluster.internal.vm.ClusterQueueNameResolver;
import com.mulesoft.mule.runtime.module.cluster.internal.vm.HazelcastQueueTransactionContext;
import java.util.concurrent.TimeUnit;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.transaction.Transaction;
import org.mule.runtime.core.api.transaction.TransactionCoordination;
import org.mule.runtime.core.api.transaction.xa.ResourceManagerException;
import org.mule.runtime.core.api.util.queue.QueueSession;
import org.mule.runtime.core.internal.util.queue.AbstractQueueSession;
import org.mule.runtime.core.internal.util.queue.QueueProvider;
import org.mule.runtime.core.internal.util.queue.QueueTransactionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterQueueSession
extends AbstractQueueSession
implements QueueSession {
    private transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private final HazelcastInstance hazelcastInstance;
    private final ClusterQueueNameResolver clusterQueueNameResolver;
    private HazelcastQueueTransactionContext queueTransactionContext;
    private TransactionContext transactionContext;
    private Integer xaTransactionTimeout;

    public ClusterQueueSession(HazelcastInstance hazelcastInstance, QueueProvider queueProvider, ClusterQueueNameResolver clusterQueueNameResolver, MuleContext muleContext) {
        super(queueProvider, muleContext);
        this.hazelcastInstance = hazelcastInstance;
        this.clusterQueueNameResolver = clusterQueueNameResolver;
    }

    @Override
    protected QueueTransactionContext getTransactionalContext() {
        return this.queueTransactionContext;
    }

    @Override
    public void begin() throws ResourceManagerException {
        TransactionOptions options = TransactionOptions.getDefault().setTransactionType(TransactionOptions.TransactionType.TWO_PHASE);
        Transaction transaction = TransactionCoordination.getInstance().getTransaction();
        if (transaction != null) {
            options.setTimeout((long)transaction.getTimeout(), TimeUnit.MILLISECONDS);
        }
        this.transactionContext = this.hazelcastInstance.newTransactionContext(options);
        this.transactionContext.beginTransaction();
        this.queueTransactionContext = new HazelcastQueueTransactionContext(this.transactionContext, this.clusterQueueNameResolver, this.getMuleContext().getObjectSerializer());
    }

    @Override
    public void commit() throws ResourceManagerException {
        this.transactionContext.commitTransaction();
        this.transactionContext = null;
        this.queueTransactionContext = null;
    }

    @Override
    public void rollback() throws ResourceManagerException {
        this.transactionContext.rollbackTransaction();
        this.transactionContext = null;
        this.queueTransactionContext = null;
    }

    @Override
    public void commit(Xid xid, boolean onePhase) throws XAException {
        try {
            if (this.queueTransactionContext == null) {
                this.hazelcastInstance.getXAResource().commit(xid, onePhase);
                this.transactionContext = this.getXaTransactionContext();
            } else {
                this.hazelcastInstance.getXAResource().commit(xid, onePhase);
                this.transactionContext = null;
                this.queueTransactionContext = null;
            }
        }
        catch (Exception e) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Cannot commit transaction", (Throwable)e);
            }
            throw new XAException(104);
        }
    }

    @Override
    public void end(Xid xid, int flag) throws XAException {
        this.hazelcastInstance.getXAResource().end(xid, flag);
    }

    @Override
    public void forget(Xid xid) throws XAException {
        this.hazelcastInstance.getXAResource().forget(xid);
        this.transactionContext = null;
        this.queueTransactionContext = null;
    }

    @Override
    public int getTransactionTimeout() throws XAException {
        return this.hazelcastInstance.getXAResource().getTransactionTimeout();
    }

    @Override
    public boolean isSameRM(XAResource xaResource) throws XAException {
        if (xaResource instanceof ClusterQueueSession) {
            xaResource = ((ClusterQueueSession)xaResource).hazelcastInstance.getXAResource();
        }
        return this.hazelcastInstance.getXAResource().isSameRM(xaResource);
    }

    @Override
    public int prepare(Xid xid) throws XAException {
        return this.hazelcastInstance.getXAResource().prepare(xid);
    }

    @Override
    public Xid[] recover(int flag) throws XAException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Recovery called on cluster session with flag " + flag);
        }
        Xid[] recover = this.hazelcastInstance.getXAResource().recover(flag);
        this.transactionContext = this.getXaTransactionContext();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(String.format("Cluster queue session recover return %s dangling transactions", recover != null ? recover.length : 0));
        }
        return recover;
    }

    @Override
    public void rollback(Xid xid) throws XAException {
        this.hazelcastInstance.getXAResource().rollback(xid);
        this.transactionContext = null;
        this.queueTransactionContext = null;
    }

    @Override
    public boolean setTransactionTimeout(int timeout) throws XAException {
        this.xaTransactionTimeout = timeout;
        return true;
    }

    @Override
    public void start(Xid xid, int i) throws XAException {
        this.hazelcastInstance.getXAResource().start(xid, i);
        this.transactionContext = this.getXaTransactionContext();
        if (this.xaTransactionTimeout != null) {
            this.hazelcastInstance.getXAResource().setTransactionTimeout(this.xaTransactionTimeout.intValue());
            this.xaTransactionTimeout = null;
        }
        this.queueTransactionContext = new HazelcastQueueTransactionContext(this.transactionContext, this.clusterQueueNameResolver, this.getMuleContext().getObjectSerializer());
    }

    private TransactionContext getXaTransactionContext() {
        return this.hazelcastInstance.getXAResource().getTransactionContext();
    }
}

