/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.module.license.internal;

import com.mulesoft.licm.impl.MuleLicenseInterrupter;
import com.mulesoft.mule.runtime.core.api.license.MuleLicenseUtils;
import com.mulesoft.mule.runtime.core.api.license.NoValidLicenseFoundException;
import com.mulesoft.mule.runtime.module.license.internal.CustomerLicense;
import com.mulesoft.mule.runtime.module.license.internal.ProviderLicense;
import com.mulesoft.mule.runtime.module.license.internal.SecurityUtils;
import java.security.InvalidKeyException;
import java.security.PublicKey;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.module.license.api.LicenseValidator;
import org.mule.runtime.module.license.api.PluginLicenseValidationRequest;
import org.mule.runtime.module.license.api.exception.InvalidLicenseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EeLicenseValidator
implements LicenseValidator,
Disposable {
    private static final Logger LOGGER = LoggerFactory.getLogger(EeLicenseValidator.class);
    private static final String MISSING_ENTITLEMENT_MSG = "The Module %s requires a license with entitlement for %s";
    private static final String PLEASE_CONTACT_MSH = "Please Contact: %s";
    private static final String MULE_PUB_KEY = "mule.pub";
    private final PublicKey mulePublicKey;

    public EeLicenseValidator() {
        try {
            this.mulePublicKey = SecurityUtils.loadPublic(MULE_PUB_KEY);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void validatePluginLicense(PluginLicenseValidationRequest pluginLicenseValidationRequest) {
        if (EeLicenseValidator.isTestMode()) {
            LOGGER.debug("Running in testing mode, disabling plugin license validation");
            return;
        }
        try {
            if (pluginLicenseValidationRequest.isAllowsEvaluation() && MuleLicenseUtils.getLicense().isEvaluation()) {
                return;
            }
        }
        catch (NoValidLicenseFoundException e) {
            this.throwRuntimeLicenseNotFoundException(e);
            return;
        }
        if (pluginLicenseValidationRequest.getPluginProvider().equals("Mulesoft")) {
            try {
                if (!MuleLicenseUtils.getLicense().hasEntitlement(pluginLicenseValidationRequest.getEntitlement(), pluginLicenseValidationRequest.getPluginName())) {
                    throw new InvalidLicenseException(String.format("Runtime license does not contain entitlement [%s] required by plugin [%s]", pluginLicenseValidationRequest.getEntitlement(), pluginLicenseValidationRequest.getPluginName()));
                }
            }
            catch (NoValidLicenseFoundException e) {
                this.throwRuntimeLicenseNotFoundException(e);
            }
        } else {
            ProviderLicense providerLicense = null;
            try {
                LOGGER.debug("Loading provider data for plugin " + pluginLicenseValidationRequest.getPluginName());
                providerLicense = new ProviderLicense(pluginLicenseValidationRequest.getPluginProvider(), pluginLicenseValidationRequest.getPluginName(), pluginLicenseValidationRequest.getPluginClassLoader(), this.mulePublicKey);
                String expectedLicenseName = providerLicense.getExpectedLicenseName();
                LOGGER.debug("Loading custom license information from license file " + expectedLicenseName);
                CustomerLicense customLicense = new CustomerLicense(expectedLicenseName, pluginLicenseValidationRequest.getArtifactClassLoader(), providerLicense);
                if (!customLicense.isValid(pluginLicenseValidationRequest.getPluginVersion(), pluginLicenseValidationRequest.getEntitlement())) {
                    this.logInvalidLicenseError(pluginLicenseValidationRequest, providerLicense, customLicense);
                    throw new InvalidLicenseException(String.format(MISSING_ENTITLEMENT_MSG, pluginLicenseValidationRequest.getPluginName(), pluginLicenseValidationRequest.getEntitlement()) + ". " + String.format(PLEASE_CONTACT_MSH, providerLicense.getEmail()));
                }
            }
            catch (InvalidKeyException e) {
                String email = providerLicense != null ? providerLicense.getEmail() : "";
                String msg = providerLicense != null ? providerLicense.getContactMessage() : "";
                throw new InvalidLicenseException(String.format(MISSING_ENTITLEMENT_MSG, pluginLicenseValidationRequest.getPluginName(), pluginLicenseValidationRequest.getEntitlement()) + ". Contact email: " + email + ". " + msg);
            }
        }
    }

    @Override
    public void dispose() {
        MuleLicenseInterrupter.dispose();
    }

    private void throwRuntimeLicenseNotFoundException(NoValidLicenseFoundException e) {
        throw new InvalidLicenseException("runtime license not found", e);
    }

    private void logInvalidLicenseError(PluginLicenseValidationRequest pluginLicenseValidationRequest, ProviderLicense providerLicense, CustomerLicense customLicense) {
        String licName = customLicense.getLicFileName();
        if (!customLicense.hasValidVersion(pluginLicenseValidationRequest.getPluginVersion())) {
            LOGGER.error("Your license " + licName + " is not valid for this connector version: " + pluginLicenseValidationRequest.getPluginVersion());
        } else if (!customLicense.hasValidEntitlement(pluginLicenseValidationRequest.getEntitlement())) {
            LOGGER.error("Your license " + licName + "does not enable the feature [" + pluginLicenseValidationRequest.getEntitlement() + "] required by the module " + pluginLicenseValidationRequest.getPluginName());
        } else {
            LOGGER.error("Your license " + licName + " has expired on the " + customLicense.getExpirationDate());
        }
        LOGGER.error("Please get in contact with your Vendor " + providerLicense.getExpectedLicenseName() + " using the following address: " + providerLicense.getProperty("contact.email").get());
        if (providerLicense.getProperty("contact.message").isPresent()) {
            LOGGER.error(providerLicense.getProperty("contact.message").get());
        }
    }

    private static boolean isTestMode() {
        return System.getProperty("mule.testingMode") != null;
    }
}

