/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.plugin.discoverer;

import com.mulesoft.mule.runtime.plugin.discoverer.PluginDiscoverer;
import com.mulesoft.mule.runtime.plugin.factory.ServerPluginDescriptor;
import com.mulesoft.mule.runtime.plugin.factory.ServerPluginDescriptorFactory;
import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.mule.runtime.core.api.util.FileUtils;
import org.mule.runtime.deployment.model.api.artifact.DescriptorLoaderRepositoryFactory;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactDescriptorFactory;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactDescriptorValidatorBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSystemPluginDiscoverer
implements PluginDiscoverer {
    private static final String JAR_FILE = "*.jar";
    protected static final Logger logger = LoggerFactory.getLogger(FileSystemPluginDiscoverer.class);
    private final File pluginsFolder;
    private ArtifactDescriptorFactory<ServerPluginDescriptor> pluginDescriptorFactory = new ServerPluginDescriptorFactory(new DescriptorLoaderRepositoryFactory().createDescriptorLoaderRepository(), ArtifactDescriptorValidatorBuilder.builder());

    public FileSystemPluginDiscoverer(File pluginsFolder) {
        this.pluginsFolder = pluginsFolder;
    }

    @Override
    public List<ServerPluginDescriptor> discover() {
        if (!this.pluginsFolder.exists()) {
            throw new IllegalArgumentException("Plugins folder does not exist: " + this.pluginsFolder);
        }
        this.unzipNewPluginFiles();
        return this.createPluginsFromFolders();
    }

    private List<ServerPluginDescriptor> createPluginsFromFolders() {
        File[] files;
        LinkedList<ServerPluginDescriptor> result = new LinkedList<ServerPluginDescriptor>();
        for (File file : files = this.pluginsFolder.listFiles((FileFilter)DirectoryFileFilter.DIRECTORY)) {
            try {
                ServerPluginDescriptor descriptor = this.pluginDescriptorFactory.create(file, Optional.empty());
                result.add(descriptor);
            }
            catch (Exception e) {
                logger.warn(String.format("Cannot load descriptor for plugin '%s': %s (%s)", file.getName(), e.getMessage(), e.getClass().getName()));
            }
        }
        return result;
    }

    private void unzipNewPluginFiles() {
        File[] files;
        WildcardFileFilter fileFilter = new WildcardFileFilter(JAR_FILE);
        for (File file : files = this.pluginsFolder.listFiles((FilenameFilter)fileFilter)) {
            try {
                if (logger.isInfoEnabled()) {
                    logger.info("Unzipping plugin file: " + file.getName());
                }
                File pluginFolder = new File(this.pluginsFolder, FilenameUtils.getBaseName((String)file.getName()));
                FileUtils.unzip(file, pluginFolder);
            }
            catch (Exception e) {
                logger.warn(String.format("Cannot unzip plugin file '%s'", file.getName()));
            }
            if (file.delete()) continue;
            logger.warn(String.format("Cannot delete plugin file '%s'. Plugin will be overwritten on restart", file.getName()));
        }
    }

    public void setPluginDescriptorFactory(ArtifactDescriptorFactory<ServerPluginDescriptor> pluginDescriptorFactory) {
        this.pluginDescriptorFactory = pluginDescriptorFactory;
    }
}

