/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.el.function;

import javax.inject.Inject;
import javax.inject.Named;
import org.mule.runtime.api.component.ConfigurationProperties;
import org.mule.runtime.api.component.location.ConfigurationComponentLocator;
import org.mule.runtime.api.el.BindingContext;
import org.mule.runtime.api.exception.ErrorTypeRepository;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.core.internal.el.function.CausedByFunction;
import org.mule.runtime.core.internal.el.function.LookupFunction;
import org.mule.runtime.core.internal.el.function.PropertyAccessFunction;
import org.mule.runtime.core.privileged.el.GlobalBindingContextProvider;

public class MuleFunctionsBindingContextProvider
implements GlobalBindingContextProvider {
    public static final String CORE_FUNCTIONS_PROVIDER_REGISTRY_KEY = "core.global.binding.provider";
    private ConfigurationProperties configurationProperties;
    @Inject
    @Named(value="_muleConfigurationComponentLocator")
    private ConfigurationComponentLocator componentLocator;
    @Inject
    private ErrorTypeRepository errorTypeRepository;
    @Inject
    private SchedulerService schedulerService;
    private PropertyAccessFunction propertyFunction;

    @Override
    public BindingContext getBindingContext() {
        BindingContext.Builder builder = BindingContext.builder();
        this.propertyFunction = new PropertyAccessFunction();
        this.propertyFunction.setConfigurationProperties(this.configurationProperties);
        builder.addBinding("p", new TypedValue<PropertyAccessFunction>(this.propertyFunction, DataType.fromFunction(this.propertyFunction)));
        LookupFunction lookupFunction = new LookupFunction(this.componentLocator, this.schedulerService);
        builder.addBinding("lookup", new TypedValue<LookupFunction>(lookupFunction, DataType.fromFunction(lookupFunction)));
        CausedByFunction causedByFunction = new CausedByFunction(this.errorTypeRepository);
        builder.addBinding("causedBy", new TypedValue<CausedByFunction>(causedByFunction, DataType.fromFunction(causedByFunction)));
        return builder.build();
    }

    @Inject
    @Named(value="_muleConfigurationAttributesResolver")
    public void setConfigurationProperties(ConfigurationProperties configurationProperties) {
        this.configurationProperties = configurationProperties;
        if (this.propertyFunction != null) {
            this.propertyFunction.setConfigurationProperties(configurationProperties);
        }
    }
}

