/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.profiling.consumer;

import com.google.common.collect.ImmutableSet;
import com.google.gson.Gson;
import java.util.Set;
import java.util.function.Predicate;
import org.mule.runtime.api.profiling.ProfilingDataConsumer;
import org.mule.runtime.api.profiling.type.ProfilingEventType;
import org.mule.runtime.api.profiling.type.RuntimeProfilingEventTypes;
import org.mule.runtime.api.profiling.type.context.ByteBufferProviderEventContext;
import org.mule.runtime.core.internal.profiling.consumer.ComponentProfilingUtils;
import org.mule.runtime.core.internal.profiling.consumer.annotations.RuntimeInternalProfilingDataConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RuntimeInternalProfilingDataConsumer
public class LoggerByteBufferAllocationProfilingDataConsumer
implements ProfilingDataConsumer<ByteBufferProviderEventContext> {
    private static final Logger LOGGER = LoggerFactory.getLogger(LoggerByteBufferAllocationProfilingDataConsumer.class);
    private final Gson gson = new Gson();

    @Override
    public void onProfilingEvent(ProfilingEventType<ByteBufferProviderEventContext> profilingEventType, ByteBufferProviderEventContext profilingEventContext) {
        Logger logger = this.getDataConsumerLogger();
        if (logger.isDebugEnabled()) {
            logger.debug(this.gson.toJson(ComponentProfilingUtils.getByteBufferProfilingInfo(profilingEventType, profilingEventContext)));
        }
    }

    @Override
    public Set<ProfilingEventType<ByteBufferProviderEventContext>> getProfilingEventTypes() {
        return ImmutableSet.of(RuntimeProfilingEventTypes.MEMORY_BYTE_BUFFER_ALLOCATION, RuntimeProfilingEventTypes.MEMORY_BYTE_BUFFER_DEALLOCATION);
    }

    @Override
    public Predicate<ByteBufferProviderEventContext> getEventContextFilter() {
        return processingStrategyProfilingEventContext -> true;
    }

    protected Logger getDataConsumerLogger() {
        return LOGGER;
    }
}

