/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.metrics.impl.instrument;

import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.mule.runtime.metrics.api.instrument.LongUpDownCounter;
import org.mule.runtime.metrics.api.instrument.builder.LongUpDownCounterBuilder;
import org.mule.runtime.metrics.api.meter.Meter;
import org.mule.runtime.metrics.exporter.api.MeterExporter;
import org.mule.runtime.metrics.impl.instrument.repository.InstrumentRepository;

public class DefaultLongUpDownCounter
implements LongUpDownCounter {
    private final String name;
    private final String description;
    private final long initialValue;
    private final String unit;
    private final Meter meter;
    private final AtomicLong value;
    private Consumer<Long> consumerForAddOperation;
    private Supplier<Long> supplierForIncrementAndGetOperation;
    private Supplier<Long> supplierForDecrementAndGetOperation;
    private Supplier<Long> valueSupplier;

    public static DefaultLongUpDownCounterBuilder builder(String name, Meter meter) {
        return new DefaultLongUpDownCounterBuilder(name, meter);
    }

    private DefaultLongUpDownCounter(String name, String description, String unit, long initialValue, Meter meter) {
        this.name = name;
        this.description = description;
        this.initialValue = initialValue;
        this.value = new AtomicLong(initialValue);
        this.valueSupplier = this.value::get;
        this.supplierForDecrementAndGetOperation = this.value::decrementAndGet;
        this.supplierForIncrementAndGetOperation = this.value::incrementAndGet;
        this.consumerForAddOperation = this.value::addAndGet;
        this.unit = unit;
        this.meter = meter;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void add(long value) {
        this.consumerForAddOperation.accept(value);
    }

    @Override
    public long getValueAsLong() {
        return this.valueSupplier.get();
    }

    @Override
    public int getValueAsInt() {
        return this.valueSupplier.get().intValue();
    }

    @Override
    public String getUnit() {
        return this.unit;
    }

    @Override
    public Meter getMeter() {
        return this.meter;
    }

    @Override
    public int incrementAndGetAsInt() {
        return this.supplierForIncrementAndGetOperation.get().intValue();
    }

    @Override
    public long incrementAndGetAsLong() {
        return this.supplierForIncrementAndGetOperation.get();
    }

    @Override
    public int decrementAndGetAsInt() {
        return this.supplierForDecrementAndGetOperation.get().intValue();
    }

    @Override
    public long decrementAndGetAsLong() {
        return this.supplierForDecrementAndGetOperation.get();
    }

    private void setValueSupplier(Supplier<Long> valueSupplier) {
        this.valueSupplier = valueSupplier;
    }

    private void setSupplierForDecrementAndGetOperation(Supplier<Long> supplierForDecrementAndGetOperation) {
        this.supplierForDecrementAndGetOperation = supplierForDecrementAndGetOperation;
    }

    private void setSupplierForIncrementAndGetOperation(Supplier<Long> supplierForIncrementAndGetOperation) {
        this.supplierForIncrementAndGetOperation = supplierForIncrementAndGetOperation;
    }

    private void setConsumerForAddOperation(Consumer<Long> consumerForAddOperation) {
        this.consumerForAddOperation = consumerForAddOperation;
    }

    @Override
    public void reset() {
        this.value.set(this.initialValue);
    }

    public static class DefaultLongUpDownCounterBuilder
    implements LongUpDownCounterBuilder {
        private final String name;
        private final Meter meter;
        private InstrumentRepository instrumentRepository;
        private String description;
        private String unit;
        private long initialValue;
        private MeterExporter meterExporter;
        private Consumer<Long> consumerForAddOperation;
        private Supplier<Long> supplierForIncrementAndGetOperation;
        private Supplier<Long> supplierForDecrementAndGetOperation;
        private Supplier<Long> valueSupplier;

        public DefaultLongUpDownCounterBuilder(String name, Meter meter) {
            this.name = name;
            this.meter = meter;
        }

        public DefaultLongUpDownCounterBuilder withDescription(String description) {
            this.description = description;
            return this;
        }

        public DefaultLongUpDownCounterBuilder withUnit(String unit) {
            this.unit = unit;
            return this;
        }

        @Override
        public DefaultLongUpDownCounterBuilder withInitialValue(long initialValue) {
            this.initialValue = initialValue;
            return this;
        }

        public DefaultLongUpDownCounterBuilder withInstrumentRepository(InstrumentRepository instrumentRepository) {
            this.instrumentRepository = instrumentRepository;
            return this;
        }

        public DefaultLongUpDownCounterBuilder withMeterExporter(MeterExporter meterExporter) {
            this.meterExporter = meterExporter;
            return this;
        }

        @Override
        public DefaultLongUpDownCounterBuilder withConsumerForAddOperation(Consumer<Long> consumerForAddOperation) {
            this.consumerForAddOperation = consumerForAddOperation;
            return this;
        }

        @Override
        public DefaultLongUpDownCounterBuilder withSupplierForIncrementAndGetOperation(Supplier<Long> supplierForIncrementAndGetOperation) {
            this.supplierForIncrementAndGetOperation = supplierForIncrementAndGetOperation;
            return this;
        }

        @Override
        public DefaultLongUpDownCounterBuilder withSupplierForDecrementAndGetOperation(Supplier<Long> supplierForDecrementAndGetOperation) {
            this.supplierForDecrementAndGetOperation = supplierForDecrementAndGetOperation;
            return this;
        }

        @Override
        public LongUpDownCounterBuilder withValueSupplier(Supplier<Long> valueSupplier) {
            this.valueSupplier = valueSupplier;
            return this;
        }

        @Override
        public LongUpDownCounter build() {
            LongUpDownCounter longUpDownCounter = Optional.ofNullable(this.instrumentRepository).map(repository -> (LongUpDownCounter)repository.create(this.name, name -> this.doBuild((String)name, this.description, this.unit, this.initialValue, this.meter))).orElse(this.doBuild(this.name, this.description, this.unit, this.initialValue, this.meter));
            if (this.meterExporter != null) {
                this.meterExporter.enableExport(longUpDownCounter);
            }
            return longUpDownCounter;
        }

        private LongUpDownCounter doBuild(String name, String description, String unit, long initialValue, Meter meter) {
            DefaultLongUpDownCounter longUpDownCounter = new DefaultLongUpDownCounter(name, description, unit, initialValue, meter);
            if (this.consumerForAddOperation != null) {
                longUpDownCounter.setConsumerForAddOperation(this.consumerForAddOperation);
            }
            if (this.supplierForIncrementAndGetOperation != null) {
                longUpDownCounter.setSupplierForIncrementAndGetOperation(this.supplierForIncrementAndGetOperation);
            }
            if (this.supplierForDecrementAndGetOperation != null) {
                longUpDownCounter.setSupplierForDecrementAndGetOperation(this.supplierForDecrementAndGetOperation);
            }
            if (this.valueSupplier != null) {
                longUpDownCounter.setValueSupplier(this.valueSupplier);
            }
            return longUpDownCounter;
        }
    }
}

