/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 */
package org.mule.test.plugin;

import static org.mule.runtime.core.api.util.ClassUtils.isClassOnPath;

public class ClassFromPluginWithProvidedB1C1 {

  public ClassFromPluginWithProvidedB1C1() {

    //Check that class from dependency-b:1.0.0 is present
    if(!isClassOnPath("org.mule.test.dependency.ClassFromDependencyB1", getClass())) {
      throw new RuntimeException("ClassFromDependencyB1 not present at runtime");
    }

    //Check that class from dependency-c:1.0.0 is present
    if(!isClassOnPath("org.mule.test.dependency.ClassFromDependencyC1", getClass())) {
      throw new RuntimeException("ClassFromDependencyC1 not present at runtime");
    }

    //Check that class from dependency-a is present
    if(!isClassOnPath("org.mule.test.dependency.ClassFromDependencyA", getClass())) {
      throw new RuntimeException("ClassFromDependencyA not present at runtime");
    }

    String depAVersion;
    try {
      depAVersion = (String) Class.forName("org.mule.test.dependency.ClassFromDependencyA").getField("VERSION").get(null);
    }catch(Exception e) {
      throw new RuntimeException("Failure when accessing ClassFromDependencyA fields");
    }
    if (!depAVersion.equals("1.1.0")) {
      throw new RuntimeException("ClassFromDependencyA has an unexpected version: " + depAVersion);
    }


    //Check that class from dependency-a:1.0.0 is not present
    if(isClassOnPath("org.mule.test.dependency.ClassFromDependencyA1", getClass())) {
      throw new RuntimeException("ClassFromDependencyA1 not expected at runtime");
    }

    //Check that class from dependency-a:1.1.0 is present
    if(!isClassOnPath("org.mule.test.dependency.ClassFromDependencyA11", getClass())) {
      throw new RuntimeException("ClassFromDependencyA11 not present at Runtime");
    }
  }
}