/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 */
package org.mule.test.plugin;

import static org.mule.runtime.core.api.util.ClassUtils.isClassOnPath;

public class ClassFromPluginWithProvidedA1 {

  public ClassFromPluginWithProvidedA1() {

    if(!isClassOnPath("org.mule.test.dependency.ClassFromDependencyA", getClass())) {
      throw new RuntimeException("ClassFromDependencyA not present at runtime");
    }

    String depAVersion;
    try {
      depAVersion = (String) Class.forName("org.mule.test.dependency.ClassFromDependencyA").getField("VERSION").get(null);
    }catch(Exception e) {
      throw new RuntimeException("Failure when accessing ClassFromDependencyA fields");
    }
    if (!depAVersion.equals("1.0.0")) {
      throw new RuntimeException("ClassFromDependencyA has an unexpected version " + depAVersion);
    }

    if(!isClassOnPath("org.mule.test.dependency.ClassFromDependencyA1", getClass())) {
      throw new RuntimeException("ClassFromDependencyA1 not present at runtime");
    }
  }
}