/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 */
import static java.lang.ModuleLayer.boot;
import static java.lang.module.ModuleFinder.ofSystem;
import static java.util.stream.Collectors.toSet;

import static org.hamcrest.collection.IsEmptyIterable.emptyIterable;
import static org.junit.Assert.assertThat;
import static org.slf4j.LoggerFactory.getLogger;

import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.InitialisationException;

import com.mulesoft.mule.runtime.module.plugin.api.management.MuleInstanceManager;
import com.mulesoft.mule.runtime.module.plugin.api.management.MuleInstanceManagerAware;
import com.mulesoft.mule.runtime.module.plugin.api.MulePlugin;

import java.io.File;
import java.lang.Class;
import java.lang.module.ModuleReference;
import java.util.Set;

import jakarta.inject.Inject;

import org.slf4j.Logger;

public class AssertJvmModulesAccessiblePlugin implements MulePlugin {

  private static Logger logger = getLogger(AssertJvmModulesAccessiblePlugin.class);

  @Inject
  private MuleInstanceManager muleInstanceManager;

  @Override
  public void setWorkingDirectory(File directory) {
    // nothing to do
  }

  @Override
  public void dispose() {}

  @Override
  public void initialise() throws InitialisationException {
    // These are all available system modules in the jdk, regardless of the module path set.
    Set<String> systemModules = ofSystem().findAll()
        .stream()
        .map(moduleRef -> moduleRef.descriptor().name())
        // Only validate against standard java modules
        .filter(moduleName -> moduleName.startsWith("java."))
        .collect(toSet());

    // These are the modules available in the boot layer, according to the java command parameters
    boot().modules()
        .stream()
        .map(moduleRef -> moduleRef.getName())
        .forEach(systemModules::remove);

    assertThat(systemModules, emptyIterable());
    logger.error("AssertJvmModulesAccessiblePlugin assertion OK.");
  }

  @Override
  public void start() throws MuleException {}

  @Override
  public void stop() throws MuleException {}

  @Override
  public boolean isDisabledOnEnvironment() {
    return false;
  }
}
