/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 */
import static java.lang.Thread.currentThread;
import static java.util.concurrent.Executors.newScheduledThreadPool;
import static java.util.concurrent.TimeUnit.SECONDS;
import static org.slf4j.LoggerFactory.getLogger;

import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.InitialisationException;

import com.mulesoft.mule.runtime.module.plugin.api.management.MuleInstanceManager;
import com.mulesoft.mule.runtime.module.plugin.api.management.MuleInstanceManagerAware;

import java.io.File;

import jakarta.inject.Inject;

import org.slf4j.Logger;

import com.mulesoft.mule.runtime.module.plugin.api.MulePlugin;

public class ManagerPluginStops implements MulePlugin {

  private static Logger logger = getLogger(ManagerPluginStops.class);

  protected File directory;

  @Inject
  private MuleInstanceManager muleInstanceManager;

  @Override
  public void setWorkingDirectory(File directory) {
    this.directory = directory;
  }

  @Override
  public void dispose() {}

  @Override
  public void initialise() throws InitialisationException {}

  @Override
  public void start() throws MuleException {
    logger.info("Scheduling shutdown...");
    newScheduledThreadPool(1).schedule(() -> {
      logger.info("Shutting down...");
      try {
        muleInstanceManager.stop(-130);
      } catch (Throwable t) {
        logger.error("Error shutting down", t);
      }
    }, 15, SECONDS);
  }

  @Override
  public void stop() throws MuleException {
  }

  @Override
  public boolean isDisabledOnEnvironment() {
    return false;
  }
}