/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.bootstrap;

import com.mulesoft.mule.bootstrap.CommandLineParser;
import com.mulesoft.mule.bootstrap.WrapperlessArgumentsResolutionResult;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class WrapperlessArgumentsResolver {
    private static final String WRAPPER_ADDITIONAL_PREFIX = "wrapper.java.additional.";
    private static final String WRAPPER_JAVA_PREFIX = "wrapper.java.";
    private static final String WRAPPER_STRIP_QUOTES_SUFFIX = ".stripquotes";
    private static final Pattern ENV_VAR_REGEX = Pattern.compile("%([^%]*)%");
    private static final String OPTIONS_OUT_FILE_OPTION = "OPTIONS_OUT_FILE";
    private final List<String> options = new ArrayList<String>();
    private final List<String> classPaths = new ArrayList<String>();
    private final List<String> libraryPaths = new ArrayList<String>();
    private String mainClass = null;
    private final List<String> appArguments = new ArrayList<String>();
    private final Function<String, String> envVarsResolver;

    public static void main(String[] args) {
        CommandLineParser commandLineParser = new CommandLineParser().withOption(OPTIONS_OUT_FILE_OPTION, "A file to dump the resolved options to the java command").withRequiredPositionalArgument("MULE_HOME");
        try {
            commandLineParser.parse(args);
        }
        catch (IllegalArgumentException e) {
            System.err.println(e.getMessage());
            commandLineParser.printUsage();
            System.exit(-1);
        }
        if (commandLineParser.getBooleanOption("help")) {
            commandLineParser.printUsage();
            System.exit(0);
        }
        String muleHome = commandLineParser.getRequiredPositionalArgument(0);
        Optional<String> optionsOutFile = commandLineParser.getOptionValue(OPTIONS_OUT_FILE_OPTION);
        if (optionsOutFile.isPresent()) {
            WrapperlessArgumentsResolutionResult result = WrapperlessArgumentsResolver.doResolve(null, muleHome, commandLineParser.getAdditionalArguments());
            try {
                WrapperlessArgumentsResolver.dump(WrapperlessArgumentsResolver.quote(result.getOptions()), optionsOutFile.get());
            }
            catch (FileNotFoundException e) {
                System.err.printf("Unable to dump options to file: %s", e.getMessage());
                System.exit(-2);
            }
            System.out.println(String.join((CharSequence)" ", WrapperlessArgumentsResolver.quote(result.getMainClassAndArgs())));
        } else {
            System.out.println(String.join((CharSequence)" ", WrapperlessArgumentsResolver.quote(WrapperlessArgumentsResolver.resolve(muleHome, commandLineParser.getAdditionalArguments()))));
        }
    }

    public static List<String> resolve(String muleHome, String ... additionalArgs) {
        return WrapperlessArgumentsResolver.resolve(null, muleHome, additionalArgs);
    }

    static List<String> resolve(Function<String, String> envVarsResolver, String muleHome, String ... additionalArgs) {
        return WrapperlessArgumentsResolver.doResolve(envVarsResolver, muleHome, additionalArgs).getAllArguments();
    }

    private static WrapperlessArgumentsResolutionResult doResolve(Function<String, String> envVarsResolver, String muleHome, String ... additionalArgs) {
        WrapperlessArgumentsResolver resolvedArgumentsBuilder = new WrapperlessArgumentsResolver(envVarsResolver);
        resolvedArgumentsBuilder.loadOptionsFromWrapperConf(muleHome);
        resolvedArgumentsBuilder.addOption("-Dmule.bootstrap.container.wrapper.class=org.mule.runtime.module.boot.internal.MuleContainerBasicWrapper");
        resolvedArgumentsBuilder.loadFromAdHocOptions(additionalArgs);
        resolvedArgumentsBuilder.addAppArguments(Arrays.asList(additionalArgs));
        resolvedArgumentsBuilder.loadOptionsFromJvmDependantWrapperConf(muleHome);
        return resolvedArgumentsBuilder.resolve();
    }

    private static void dump(List<String> args, String fileName) throws FileNotFoundException {
        try (PrintWriter writer = new PrintWriter(fileName);){
            for (String arg : args) {
                writer.println(arg);
            }
        }
    }

    public WrapperlessArgumentsResolver(Function<String, String> envVarsResolver) {
        this.envVarsResolver = envVarsResolver != null ? envVarsResolver : System::getenv;
    }

    private void loadOptionsFromJvmDependantWrapperConf(String muleHome) {
        String jvmDependantPathPart = "java11-plus";
        Path wrapperJvmDepPath = Paths.get(muleHome, "conf", jvmDependantPathPart, "wrapper.jvmDependant.conf");
        this.loadFromConfFile(wrapperJvmDepPath);
    }

    private void loadOptionsFromWrapperConf(String muleHome) {
        Path wrapperConfPath = Paths.get(muleHome, "conf", "wrapper.conf");
        this.loadFromConfFile(wrapperConfPath);
    }

    private void addOption(String option) {
        this.options.add(option);
    }

    private void addClassPath(String classPath) {
        String expandedClassPath = this.expandClassPathWildcards(classPath);
        if (!expandedClassPath.isEmpty()) {
            this.classPaths.add(expandedClassPath);
        }
    }

    private void addLibraryPaths(String libraryPath) {
        this.libraryPaths.add(libraryPath);
    }

    private void setMainClass(String mainClass) {
        this.mainClass = mainClass;
    }

    private void addAppArguments(List<String> appArguments) {
        this.appArguments.addAll(appArguments);
    }

    public void loadFromConfFile(Path confFilePath) {
        Properties props = new Properties();
        try {
            props.load(new FileInputStream(confFilePath.toFile()));
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("There was a problem resolving arguments from %s", confFilePath), e);
        }
        for (Map.Entry<Object, Object> wrapperEntry : props.entrySet()) {
            String key = wrapperEntry.getKey().toString();
            String value = this.substituteEnvVariables(wrapperEntry.getValue().toString());
            if (key.startsWith(WRAPPER_ADDITIONAL_PREFIX) && !key.endsWith(WRAPPER_STRIP_QUOTES_SUFFIX)) {
                if (Boolean.parseBoolean(props.getProperty(key + WRAPPER_STRIP_QUOTES_SUFFIX))) {
                    value = WrapperlessArgumentsResolver.stripQuotes(value);
                }
                if (value.startsWith("--add-modules=")) {
                    this.addOption(this.excludeTanukiModules(value));
                    continue;
                }
                if (value.startsWith("--module-path=")) {
                    this.addOption(this.excludeTanukiPaths(value));
                    continue;
                }
                this.addOption(value);
                continue;
            }
            if (key.equals("wrapper.java.initmemory")) {
                this.addOption(String.format("-Xms%sm", value));
                continue;
            }
            if (key.equals("wrapper.java.maxmemory")) {
                this.addOption(String.format("-Xmx%sm", value));
                continue;
            }
            if (key.startsWith("wrapper.java.classpath.")) {
                this.addClassPath(value);
                continue;
            }
            if (key.startsWith("wrapper.java.library.path.")) {
                this.addLibraryPaths(value);
                continue;
            }
            if (!key.equals("wrapper.java.mainclass")) continue;
            this.setMainClass(value);
        }
    }

    public void loadFromAdHocOptions(String ... options) {
        for (String adHocOption : options) {
            if (!adHocOption.startsWith("-M") && !adHocOption.startsWith("\"-M")) continue;
            this.addOption(WrapperlessArgumentsResolver.stripQuotes(WrapperlessArgumentsResolver.removeAdHocPrefix(adHocOption)));
        }
    }

    public WrapperlessArgumentsResolutionResult resolve() {
        if (this.mainClass == null) {
            throw new IllegalArgumentException("Main Class missing");
        }
        ArrayList<String> allOptions = new ArrayList<String>(this.options);
        if (!this.classPaths.isEmpty()) {
            allOptions.add("-classpath");
            allOptions.add(String.join((CharSequence)":", this.classPaths));
        }
        if (!this.libraryPaths.isEmpty()) {
            allOptions.add("-Djava.library.path=" + String.join((CharSequence)":", this.libraryPaths));
        }
        return new WrapperlessArgumentsResolutionResult(allOptions, this.mainClass, this.appArguments);
    }

    private String substituteEnvVariables(String propValue) {
        Matcher envVarMatcher = ENV_VAR_REGEX.matcher(propValue);
        StringBuffer sb = new StringBuffer();
        while (envVarMatcher.find()) {
            envVarMatcher.appendReplacement(sb, this.envVarLookUp(envVarMatcher.group(1)));
        }
        envVarMatcher.appendTail(sb);
        return sb.toString();
    }

    private String envVarLookUp(String envVarName) {
        String envVarValue = this.envVarsResolver.apply(envVarName);
        return envVarValue != null ? envVarValue : envVarName;
    }

    private static String removeAdHocPrefix(String arg) {
        if (arg.startsWith("\"-M")) {
            return arg.replaceFirst("\"-M", "\"");
        }
        return arg.substring(2);
    }

    private static String stripQuotes(String value) {
        StringBuilder sb = new StringBuilder(value.length());
        int len = value.length();
        for (int i = 0; i < len; ++i) {
            char curChar = value.charAt(i);
            if (curChar == '\\' && i < len - 1) {
                char nextChar = value.charAt(i + 1);
                if (nextChar == '\\') {
                    sb.append(curChar);
                    ++i;
                    continue;
                }
                if (nextChar == '\"') {
                    sb.append(nextChar);
                    ++i;
                    continue;
                }
                sb.append(curChar);
                continue;
            }
            if (curChar == '\"') continue;
            sb.append(curChar);
        }
        return sb.toString();
    }

    private String expandClassPathWildcards(String classPath) {
        if (!classPath.contains("*")) {
            return classPath;
        }
        String[] classPathEntries = classPath.split(":");
        ArrayList<String> expandedClassPathEntries = new ArrayList<String>(classPathEntries.length);
        for (String classPathEntry : classPathEntries) {
            expandedClassPathEntries.add(this.expandClassPathEntryWildcards(classPathEntry));
        }
        return String.join((CharSequence)":", expandedClassPathEntries);
    }

    private String expandClassPathEntryWildcards(String classPathEntry) {
        String string;
        block10: {
            if (!classPathEntry.contains("*")) {
                return classPathEntry;
            }
            FileSystem fs = FileSystems.getDefault();
            String pathBeforeWildcard = classPathEntry.split("\\*", 1)[0];
            Path basePath = Paths.get(pathBeforeWildcard, new String[0]);
            if (!pathBeforeWildcard.endsWith(fs.getSeparator())) {
                basePath = basePath.getParent();
            }
            PathMatcher pathMatcher = fs.getPathMatcher(String.format("glob:%s", classPathEntry));
            Stream<Path> foundPaths = Files.find(basePath, 1, (path, attrs) -> pathMatcher.matches((Path)path), new FileVisitOption[0]);
            try {
                string = foundPaths.map(Path::toString).filter(WrapperlessArgumentsResolver.not(this::isTanukiRelatedPath)).collect(Collectors.joining(":"));
                if (foundPaths == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (foundPaths != null) {
                        try {
                            foundPaths.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(String.format("Error expanding classpath entry: '%s'", classPathEntry), e);
                }
            }
            foundPaths.close();
        }
        return string;
    }

    private boolean isTanukiRelatedPath(String path) {
        return path.contains("lib/boot/tanuki");
    }

    private boolean isTanukiRelatedModule(String moduleName) {
        return "org.mule.boot.tanuki".equals(moduleName);
    }

    private String excludeTanukiPaths(String modulePath) {
        return WrapperlessArgumentsResolver.splitFilterAndJoin(modulePath.replace("WRAPPER_PATH_SEPARATOR", File.pathSeparator), File.pathSeparator, WrapperlessArgumentsResolver.not(this::isTanukiRelatedPath));
    }

    private String excludeTanukiModules(String addModulesOption) {
        return WrapperlessArgumentsResolver.splitFilterAndJoin(addModulesOption, ",", WrapperlessArgumentsResolver.not(this::isTanukiRelatedModule));
    }

    private static List<String> quote(List<String> args) {
        return args.stream().map(WrapperlessArgumentsResolver::quote).collect(Collectors.toList());
    }

    private static String quote(String arg) {
        return "\"" + arg.replace("\"", "\\\"") + "\"";
    }

    private static String splitFilterAndJoin(String originalValue, String delimiter, Predicate<String> filter) {
        String[] parts = originalValue.split("=", 2);
        return parts[0] + "=" + Arrays.stream(parts[1].split(delimiter)).filter(filter).collect(Collectors.joining(delimiter));
    }

    private static <T> Predicate<T> not(Predicate<T> original) {
        return original.negate();
    }
}

