/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.support.installer;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Enumeration;
import java.util.Locale;
import java.util.jar.Manifest;
import me.tongfei.progressbar.ProgressBar;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class ToolsInstaller {
    private static final String FLAG_OS = "O";
    private static final String FLAG_ARCH = "A";
    private static final String FLAG_MULE_HOME = "M";
    private static final String FLAG_HELP = "H";
    private static final String TOOLS_BASE_URL = "https://support-self-update-service.us-w1.cloudhub.io/assets/";
    private static String os = "";
    private static String arch = "";

    public static void main(String[] args) {
        System.out.println(" __ __ _  _ _   ___  __   __  ___ _____  \n|  V  | || | | | __/' _/ /__\\| __|_   _|  support tools installer\n| \\_/ | \\/ | |_| _|'._'.| \\/ | _|  | |    v" + ToolsInstaller.getInstallerVersion() + "\n|_| |_|\\__/|___|___|___/ \\__/|_|   |_|\n\n");
        String muleHome = "";
        try {
            Options options = ToolsInstaller.getOptions();
            DefaultParser parser = new DefaultParser();
            CommandLine commandLine = parser.parse(options, args);
            if (commandLine.hasOption(FLAG_HELP)) {
                String header = "\n";
                String footer = "\n";
                HelpFormatter formatter = new HelpFormatter();
                formatter.setWidth(160);
                formatter.printHelp("install_tools", header, options, footer, true);
                System.exit(0);
            }
            muleHome = ToolsInstaller.getMuleHome(commandLine);
            if (commandLine.hasOption(FLAG_ARCH)) {
                arch = (String)commandLine.getParsedOptionValue(FLAG_ARCH);
                if (!(arch = arch.toLowerCase(Locale.ENGLISH)).equals("amd64") || arch.equals("386")) {
                    ToolsInstaller.warn("arch=" + arch + " is invalid. Valid values are amd64, 386.");
                    arch = "";
                }
            }
            if (commandLine.hasOption(FLAG_OS)) {
                os = (String)commandLine.getParsedOptionValue(FLAG_OS);
                if (!arch.equals("amd64") || arch.equals("386")) {
                    ToolsInstaller.warn("os=" + os + " is invalid. Valid values are windows, darwin, linux.");
                    os = "";
                }
            }
        }
        catch (ParseException e) {
            ToolsInstaller.error("Invalid options");
            System.exit(1);
        }
        try {
            ToolsInstaller.findOSARCH();
        }
        catch (RuntimeException e) {
            ToolsInstaller.error(e.getMessage());
            System.exit(1);
        }
        ToolsInstaller.info("OS " + os + " ARCH " + arch);
        File binFolder = ToolsInstaller.getMandatoryFolder(new File(muleHome, "bin"), "bin directory doesn't exist in the provided Mule Home (" + muleHome + "), please check if the provided directory is correct.");
        String[] tools = new String[]{"support-watcher", "log-analyzer", "support-collector"};
        for (int i = 0; i < tools.length; ++i) {
            Object toolName = tools[i];
            if (os.equals("windows")) {
                toolName = (String)toolName + ".exe";
            }
            File targetFile = new File(binFolder, (String)toolName);
            try {
                ToolsInstaller.downloadFile(new URL("https://support-self-update-service.us-w1.cloudhub.io/assets//" + os + "/" + arch + "/" + (String)toolName), targetFile);
            }
            catch (Exception e) {
                ToolsInstaller.error(e.getMessage());
                System.exit(1);
            }
            if (targetFile.exists()) {
                targetFile.setExecutable(true, false);
            }
            System.out.println(targetFile.getAbsolutePath() + " downloaded.");
            try {
                ToolsInstaller.testRunFile(targetFile);
            }
            catch (IOException e) {
                ToolsInstaller.error("Can't execute " + targetFile.getAbsolutePath() + ". Check the file permissions.");
            }
            System.out.println();
        }
    }

    private static void testRunFile(File targetFile) throws IOException {
        String line;
        Process process = new ProcessBuilder(targetFile.getAbsolutePath()).start();
        InputStream is = process.getInputStream();
        InputStreamReader isr = new InputStreamReader(is);
        BufferedReader br = new BufferedReader(isr);
        int totalLines = 0;
        while ((line = br.readLine()) != null && ++totalLines <= 4) {
            System.out.println(line);
        }
        br.close();
    }

    public static File getMandatoryFolder(File muleHomeDirectory, String errorMessage) {
        if (!muleHomeDirectory.exists()) {
            ToolsInstaller.error(errorMessage);
            System.exit(0);
        }
        return muleHomeDirectory;
    }

    private static String getMuleHome(CommandLine commandLine) {
        if (commandLine.hasOption(FLAG_MULE_HOME)) {
            return commandLine.getOptionValue(FLAG_MULE_HOME);
        }
        ToolsInstaller.info("MULE_HOME is set as " + new File(System.getProperty("user.dir")).getParent());
        return new File(System.getProperty("user.dir")).getParent();
    }

    private static String getInstallerVersion() {
        try {
            Enumeration<URL> resources = ToolsInstaller.class.getClassLoader().getResources("META-INF/MANIFEST.MF");
            while (resources.hasMoreElements()) {
                String version;
                Manifest manifest = new Manifest(resources.nextElement().openStream());
                if (manifest.getMainAttributes().getValue("Main-Class") == null || !manifest.getMainAttributes().getValue("Main-Class").contains("ToolsInstaller") || (version = manifest.getMainAttributes().getValue("Specification-Version")) == null) continue;
                return version;
            }
        }
        catch (IOException E) {
            return "0.0.0";
        }
        return "0.0.0";
    }

    private static Options getOptions() {
        Options options = new Options();
        options.addOption(FLAG_MULE_HOME, "mule-home", true, "The location of the corresponding Mule installation.");
        options.addOption(FLAG_HELP, "help", false, "For help please run the script with --help option");
        options.addOption(FLAG_OS, "os", true, "Force operating system. windows / darwin / linux");
        options.addOption(FLAG_ARCH, "arch", true, "Force architecture. adm64 / 386");
        return options;
    }

    private static void downloadFile(URL url, File file) throws IOException {
        HttpURLConnection httpConnection = (HttpURLConnection)url.openConnection();
        long completeFileSize = httpConnection.getContentLength();
        BufferedInputStream bis = new BufferedInputStream(httpConnection.getInputStream());
        FileOutputStream fos = new FileOutputStream(file);
        byte[] data = new byte[1024];
        try (ProgressBar pb = new ProgressBar((file.getName() + "          ").substring(0, 20), completeFileSize);){
            int count;
            while ((count = bis.read(data, 0, 1024)) != -1) {
                fos.write(data, 0, count);
                pb.stepBy((long)count);
            }
        }
        fos.close();
    }

    private static void findOSARCH() throws RuntimeException {
        if (os.isEmpty()) {
            String osName = System.getProperty("os.name");
            if (osName == null) {
                throw new RuntimeException("System property os.name not found");
            }
            if ((osName = osName.toLowerCase(Locale.ENGLISH)).contains("windows")) {
                os = "windows";
            } else if (osName.contains("linux") || osName.contains("mpe/ix") || osName.contains("freebsd") || osName.contains("irix") || osName.contains("digital unix") || osName.contains("unix")) {
                os = "linux";
            } else if (osName.contains("mac os")) {
                os = "darwin";
            } else {
                throw new RuntimeException("OS " + osName + " is not supported. Please report it back to support.");
            }
        }
        if (arch.isEmpty()) {
            String archName = System.getProperty("os.arch");
            if (archName == null) {
                throw new RuntimeException("System property os.arch not found");
            }
            arch = "amd64".equals(archName = archName.toLowerCase(Locale.ENGLISH)) || os.equals("darwin") ? "amd64" : "386";
        }
    }

    public static void info(String text) {
        System.out.println(String.format("INFO: %s%n", text));
    }

    public static void warn(String text) {
        System.out.println(String.format("WARN: %s%n", text));
    }

    public static void error(String text) {
        System.err.println(String.format("ERROR: %s%n", text));
    }
}

