/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.debugger.client.impl;

import com.mulesoft.mule.debugger.client.IDebuggerClient;
import com.mulesoft.mule.debugger.client.impl.DebuggerConnection;
import com.mulesoft.mule.debugger.dto.Breakpoint;
import com.mulesoft.mule.debugger.dto.FieldPath;
import com.mulesoft.mule.debugger.dto.MuleMessageInfoId;
import com.mulesoft.mule.debugger.request.AddBreakpointRequest;
import com.mulesoft.mule.debugger.request.EnableExceptionBreakpointRequest;
import com.mulesoft.mule.debugger.request.ExecuteScriptRequest;
import com.mulesoft.mule.debugger.request.ExitDebuggerRequest;
import com.mulesoft.mule.debugger.request.IDebuggerRequest;
import com.mulesoft.mule.debugger.request.LoadInnerFieldsRequest;
import com.mulesoft.mule.debugger.request.NextStepRequest;
import com.mulesoft.mule.debugger.request.PauseDebuggerRequest;
import com.mulesoft.mule.debugger.request.RemoveBreakpointRequest;
import com.mulesoft.mule.debugger.request.ResumeDebuggerRequest;
import com.mulesoft.mule.debugger.request.RunToProcessorDebuggerRequest;
import com.mulesoft.mule.debugger.request.SchedulerAction;
import com.mulesoft.mule.debugger.request.SchedulerRequest;
import com.mulesoft.mule.debugger.request.UpdateFieldRequest;
import com.mulesoft.mule.debugger.response.IDebuggerResponse;
import com.mulesoft.mule.debugger.response.callback.IDebuggerResponseCallback;
import com.mulesoft.mule.debugger.response.callback.MessageTrackerDecoratorCallback;
import com.mulesoft.mule.debugger.transport.IClientDebuggerProtocol;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DebuggerClient
implements IDebuggerClient {
    private final DebuggerConnection connection;
    private final Map<IDebuggerRequest, IDebuggerResponseCallback> handler;

    DebuggerClient(DebuggerConnection connection) {
        this.connection = connection;
        this.handler = new HashMap<IDebuggerRequest, IDebuggerResponseCallback>();
    }

    @Override
    public void start(IDebuggerResponseCallback defaultHandler) throws IOException {
        this.connection.connect();
        ServerResponseService runnable = new ServerResponseService(new MessageTrackerDecoratorCallback(defaultHandler));
        new Thread((Runnable)runnable, "Debugger Client").start();
    }

    @Override
    public void exit() {
        this.sendRequest((IDebuggerRequest)new ExitDebuggerRequest());
    }

    @Override
    public void pause(List<MuleMessageInfoId> muleMessageInfoIds) {
        this.sendRequest((IDebuggerRequest)new PauseDebuggerRequest(muleMessageInfoIds));
    }

    @Override
    public void resume(MuleMessageInfoId muleMessageInfoId) {
        this.sendRequest((IDebuggerRequest)new ResumeDebuggerRequest(muleMessageInfoId));
    }

    @Override
    public void nextStep(MuleMessageInfoId muleMessageInfoId) {
        this.sendRequest((IDebuggerRequest)new NextStepRequest(muleMessageInfoId));
    }

    private IClientDebuggerProtocol getProtocol() {
        return this.connection.getProtocol();
    }

    @Override
    public void runToProcessor(String messagePath, MuleMessageInfoId muleMessageInfoId) {
        this.sendRequest((IDebuggerRequest)new RunToProcessorDebuggerRequest(messagePath, muleMessageInfoId));
    }

    @Override
    public void updateField(FieldPath path, String value, MuleMessageInfoId muleMessageInfoId) {
        this.sendRequest((IDebuggerRequest)new UpdateFieldRequest(path, value));
    }

    @Override
    public void updateField(FieldPath path, String value, MuleMessageInfoId muleMessageInfoId, IDebuggerResponseCallback callback) {
        UpdateFieldRequest request = new UpdateFieldRequest(path, value);
        if (callback != null) {
            this.registerCallback(callback, (IDebuggerRequest)request);
        }
        this.sendRequest((IDebuggerRequest)request);
    }

    @Override
    public void addBreakpoints(Breakpoint ... breakpoints) {
        this.sendRequest((IDebuggerRequest)new AddBreakpointRequest(breakpoints));
    }

    @Override
    public void removeBreakpoints(Breakpoint ... breakpoints) {
        this.sendRequest((IDebuggerRequest)new RemoveBreakpointRequest(breakpoints));
    }

    @Override
    public void enableExceptionBreakpoint(boolean enabled) {
        this.sendRequest((IDebuggerRequest)new EnableExceptionBreakpointRequest(enabled));
    }

    @Override
    public void loadInnerFields(FieldPath parentPath, MuleMessageInfoId muleMessageInfoId, IDebuggerResponseCallback callback) {
        LoadInnerFieldsRequest request = new LoadInnerFieldsRequest(parentPath);
        if (callback != null) {
            this.registerCallback(callback, (IDebuggerRequest)request);
        }
        this.sendRequest((IDebuggerRequest)request);
    }

    @Override
    public void executeScript(String script, MuleMessageInfoId muleMessageInfoId, IDebuggerResponseCallback callback) {
        ExecuteScriptRequest request = new ExecuteScriptRequest(script);
        if (callback != null) {
            this.registerCallback(callback, (IDebuggerRequest)request);
        }
        this.sendRequest((IDebuggerRequest)request);
    }

    @Override
    public void startScheduler(String appName, String flowName, boolean applyToAll, IDebuggerResponseCallback callback) {
        SchedulerRequest request = new SchedulerRequest(SchedulerAction.START, appName, flowName, applyToAll);
        if (callback != null) {
            this.registerCallback(callback, (IDebuggerRequest)request);
        }
        this.sendRequest((IDebuggerRequest)request);
    }

    @Override
    public void stopScheduler(String appName, String flowName, boolean applyToAll, IDebuggerResponseCallback callback) {
        SchedulerRequest request = new SchedulerRequest(SchedulerAction.STOP, appName, flowName, applyToAll);
        if (callback != null) {
            this.registerCallback(callback, (IDebuggerRequest)request);
        }
        this.sendRequest((IDebuggerRequest)request);
    }

    @Override
    public void triggerScheduler(String appName, String flowName, boolean applyToAll) {
        this.sendRequest((IDebuggerRequest)new SchedulerRequest(SchedulerAction.TRIGGER, appName, flowName, applyToAll));
    }

    private void sendRequest(IDebuggerRequest request) {
        if (this.getProtocol() != null) {
            this.getProtocol().sendRequest(request);
        }
    }

    protected void registerCallback(IDebuggerResponseCallback callback, IDebuggerRequest request) {
        this.handler.put(request, callback);
    }

    @Override
    public void disconnect() {
        this.connection.disconnect();
    }

    private class ServerResponseService
    implements Runnable {
        private final IDebuggerResponseCallback defaultHandler;

        public ServerResponseService(IDebuggerResponseCallback defaultHandler) {
            this.defaultHandler = defaultHandler;
        }

        private void unRegisterRequest(IDebuggerRequest request) {
            DebuggerClient.this.handler.remove(request);
        }

        @Override
        public void run() {
            IClientDebuggerProtocol protocol = DebuggerClient.this.getProtocol();
            while (DebuggerClient.this.connection.isConnected()) {
                IDebuggerResponse response = protocol.getResponse();
                IDebuggerRequest request = response.getRequest();
                if (request != null && DebuggerClient.this.handler.containsKey(request)) {
                    response.callCallback((IDebuggerResponseCallback)DebuggerClient.this.handler.get(request));
                    this.unRegisterRequest(request);
                    continue;
                }
                response.callCallback(this.defaultHandler);
            }
        }
    }
}

