/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.debugger.client.impl;

import com.mulesoft.mule.debugger.transport.IClientDebuggerProtocol;
import com.mulesoft.mule.debugger.transport.SerializeDebuggerProtocol;
import java.io.IOException;
import java.net.Socket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DebuggerConnection {
    private static final Logger logger = LoggerFactory.getLogger(DebuggerConnection.class);
    private final String hostName;
    private final int port;
    private Socket client;
    private IClientDebuggerProtocol protocol;

    DebuggerConnection(String hostName, int port) {
        this.hostName = hostName;
        this.port = port;
    }

    public boolean connect() throws IOException {
        if (!this.isConnected()) {
            this.client = new Socket(this.hostName, this.port);
            this.protocol = new SerializeDebuggerProtocol(this.client.getInputStream(), this.client.getOutputStream());
            return true;
        }
        return false;
    }

    public IClientDebuggerProtocol getProtocol() {
        return this.protocol;
    }

    public void disconnect() {
        try {
            if (this.isConnected()) {
                this.protocol.close();
                this.client.close();
            }
        }
        catch (IOException e) {
            logger.error("Error trying to disconnect", (Throwable)e);
        }
        finally {
            this.client = null;
        }
    }

    public boolean isConnected() {
        return this.client != null && this.client.isConnected() && !this.client.isClosed();
    }
}

