/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.debugger.response.callback;

import com.mulesoft.mule.debugger.dto.Breakpoint;
import com.mulesoft.mule.debugger.dto.MuleMessageInfo;
import com.mulesoft.mule.debugger.dto.ObjectFieldDefinition;
import com.mulesoft.mule.debugger.dto.ScriptResultInfo;
import com.mulesoft.mule.debugger.exception.RemoteDebugException;
import com.mulesoft.mule.debugger.response.OnExecutionStoppedResponse;
import com.mulesoft.mule.debugger.response.callback.IDebuggerResponseCallback;
import java.util.List;
import java.util.Stack;

public class MessageTrackerDecoratorCallback
implements IDebuggerResponseCallback {
    private final IDebuggerResponseCallback decorated;
    private final Stack<MuleMessageInfo> receivedMessages = new Stack();
    private String lastMessageRootId = null;
    private boolean flowChanged = false;

    public MessageTrackerDecoratorCallback(IDebuggerResponseCallback decorated) {
        this.decorated = decorated;
    }

    public void onMuleMessageArrived(MuleMessageInfo muleMessageInfo) {
        this.flowChanged = this.lastMessageRootId != null && !this.lastMessageRootId.equals(muleMessageInfo.getMuleMessageInfoId().getCorrelationId());
        this.lastMessageRootId = muleMessageInfo.getMuleMessageInfoId().getCorrelationId();
        this.receivedMessages.push(muleMessageInfo);
        this.decorated.onMuleMessageArrived(muleMessageInfo);
    }

    public void onMuleMessageLeft(MuleMessageInfo muleMessageInfo) {
        this.decorated.onMuleMessageLeft(muleMessageInfo);
    }

    public void onExceptionThrown(MuleMessageInfo muleMessageInfo, ObjectFieldDefinition exceptionThrown) {
        this.flowChanged = this.lastMessageRootId != null && !this.lastMessageRootId.equals(muleMessageInfo.getMuleMessageInfoId().getCorrelationId());
        this.lastMessageRootId = muleMessageInfo.getMuleMessageInfoId().getCorrelationId();
        this.receivedMessages.push(muleMessageInfo);
        this.decorated.onExceptionThrown(muleMessageInfo, exceptionThrown);
    }

    public void onScriptEvaluation(ScriptResultInfo info) {
        this.decorated.onScriptEvaluation(info);
    }

    public void onConnected() {
        this.decorated.onConnected();
    }

    public void onExit() {
        this.decorated.onExit();
    }

    public void onError(String error) {
        this.decorated.onError(error);
    }

    public void onBreakpointsAdded(List<Breakpoint> breakpoints) {
        this.decorated.onBreakpointsAdded(breakpoints);
    }

    public void onBreakpointsRemoved(List<Breakpoint> breakpoints) {
        this.decorated.onBreakpointsRemoved(breakpoints);
    }

    public void onFieldUpdated(ObjectFieldDefinition payload) {
        this.decorated.onFieldUpdated(payload);
    }

    public void onScriptEvaluationException(RemoteDebugException exception) {
        this.decorated.onScriptEvaluationException(exception);
    }

    public void onExceptionBreakpointStatusChange(Boolean status) {
        this.decorated.onExceptionBreakpointStatusChange(status);
    }

    public void onResume() {
        if (!this.receivedMessages.isEmpty()) {
            this.receivedMessages.pop();
        }
        if (this.receivedMessages.isEmpty() && !this.flowChanged) {
            this.lastMessageRootId = null;
            this.decorated.onResume();
        }
    }

    public void onInnerFieldsLoaded(ObjectFieldDefinition innerFields) {
        this.decorated.onInnerFieldsLoaded(innerFields);
    }

    public void onNextStepExecuted() {
        if (!this.receivedMessages.isEmpty()) {
            this.receivedMessages.pop();
            this.decorated.onNextStepExecuted();
        }
    }

    public void onRunToProcessorExecuted() {
        this.receivedMessages.pop();
        this.decorated.onRunToProcessorExecuted();
    }

    public void onSchedulerStart() {
        this.decorated.onSchedulerStart();
    }

    public void onSchedulerStop() {
        this.decorated.onSchedulerStart();
    }

    public void onSchedulerActionException(RemoteDebugException exception) {
        this.decorated.onSchedulerActionException(exception);
    }

    public void onSchedulerTrigger() {
        this.decorated.onSchedulerTrigger();
    }

    public void onExecutionStopped(OnExecutionStoppedResponse onExecutionStoppedResponse) {
        this.decorated.onExecutionStopped(onExecutionStoppedResponse);
    }
}

