/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.debugger.dto;

import java.io.Serializable;

public class Breakpoint
implements Serializable {
    private static final long serialVersionUID = -3209972216195659237L;
    private final String path;
    private final String condition;
    private final String applicationName;

    public Breakpoint(String path, String condition, String applicationName) {
        if (path == null) {
            throw new IllegalArgumentException("Path argument can not be null");
        }
        if (applicationName == null) {
            throw new IllegalArgumentException("Application Name argument can not be null");
        }
        this.path = path;
        this.condition = condition;
        this.applicationName = applicationName;
    }

    public Breakpoint(String path, String applicationName) {
        this(path, null, applicationName);
    }

    public String getPath() {
        return this.path;
    }

    public String getCondition() {
        return this.condition;
    }

    public boolean hasCondition() {
        return this.condition != null && this.condition.trim().length() > 0;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Breakpoint that = (Breakpoint)o;
        if (!this.path.equals(that.path)) {
            return false;
        }
        return this.applicationName.equals(that.applicationName);
    }

    public int hashCode() {
        int result = this.path.hashCode();
        result = 31 * result + this.applicationName.hashCode();
        return result;
    }
}

