/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.debugger.dto;

import com.mulesoft.mule.debugger.dto.FieldNode;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.StringTokenizer;

public class FieldPath
implements Serializable {
    public static final String PATH_SEPARATOR = "/";
    private static final long serialVersionUID = 3147795132969576366L;
    private final String rootExpression;
    private final List<FieldNode> orderedPathElements;

    public FieldPath(String rootExpression) {
        this.rootExpression = rootExpression;
        this.orderedPathElements = Collections.emptyList();
    }

    public FieldPath(String rootExpression, List<FieldNode> orderedPathElements) {
        this.rootExpression = rootExpression;
        this.orderedPathElements = Collections.unmodifiableList(orderedPathElements);
    }

    public String getRootExpression() {
        return this.rootExpression;
    }

    public List<FieldNode> getOrderedPathElements() {
        return this.orderedPathElements;
    }

    public FieldPath addChild(FieldNode child) {
        ArrayList<FieldNode> fieldNodePaths = new ArrayList<FieldNode>(this.orderedPathElements);
        fieldNodePaths.add(child);
        return new FieldPath(this.rootExpression, fieldNodePaths);
    }

    public String toString() {
        return "FieldPath{name='" + this.rootExpression + '\'' + ", orderedPathElements=" + this.orderedPathElements + '}';
    }

    public static FieldPath fromString(String path) {
        StringTokenizer tokenizer = new StringTokenizer(path, PATH_SEPARATOR);
        FieldPath result = null;
        while (tokenizer.hasMoreTokens()) {
            if (result == null) {
                result = new FieldPath(tokenizer.nextToken());
                continue;
            }
            result = result.addChild(new FieldNode(tokenizer.nextToken()));
        }
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FieldPath fieldPath = (FieldPath)o;
        return Objects.equals(this.rootExpression, fieldPath.rootExpression) && Objects.equals(this.orderedPathElements, fieldPath.orderedPathElements);
    }

    public int hashCode() {
        return Objects.hash(this.rootExpression, this.orderedPathElements);
    }
}

