/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.debugger.dto;

import com.mulesoft.mule.debugger.dto.FieldPath;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;

public class ObjectFieldDefinition
implements Serializable {
    private static final long serialVersionUID = 8098185197919423494L;
    private String name;
    private String className;
    private String value;
    private List<ObjectFieldDefinition> innerElements;
    private final int modifiers;
    private final FieldPath path;
    private boolean hasUnloadedChildren;
    private boolean canEdit;
    private final String dwAccessor;
    private boolean isError;

    public ObjectFieldDefinition(String name, String className, String value, List<ObjectFieldDefinition> innerElements, int modifiers, FieldPath path, boolean canEdit, String dwAccessor) {
        this.name = name;
        this.className = className;
        this.value = value;
        this.innerElements = innerElements;
        this.modifiers = modifiers;
        this.path = path;
        this.hasUnloadedChildren = false;
        this.canEdit = canEdit;
        this.dwAccessor = dwAccessor;
        this.isError = false;
    }

    public ObjectFieldDefinition(String name, String className, String value, List<ObjectFieldDefinition> innerElements, int modifiers, FieldPath path, String dwAccessor) {
        this(name, className, value, innerElements, modifiers, path, true, dwAccessor);
    }

    public ObjectFieldDefinition(String name, String className, String value, List<ObjectFieldDefinition> innerElements, FieldPath path) {
        this(name, className, value, innerElements, 0, path, true, null);
    }

    public boolean isHasUnloadedChildren() {
        return this.hasUnloadedChildren;
    }

    public void setHasUnloadedChildren(boolean hasUnloadedChildren) {
        this.hasUnloadedChildren = hasUnloadedChildren;
    }

    public String getName() {
        return this.name;
    }

    public String getClassName() {
        return this.className;
    }

    public String getValue() {
        return this.value;
    }

    public List<ObjectFieldDefinition> getInnerElements() {
        return this.innerElements;
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public FieldPath getPath() {
        return this.path;
    }

    public String toString() {
        return "ObjectFieldDefinition{name='" + this.name + '\'' + ", className='" + this.className + '\'' + ", value='" + this.value + '\'' + ", innerElements=" + this.innerElements.size() + '}';
    }

    protected void setName(String name) {
        this.name = name;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public void setValue(String value) {
        this.value = value;
    }

    protected void setInnerElements(List<ObjectFieldDefinition> innerElements) {
        this.innerElements = innerElements;
    }

    public boolean canEdit() {
        return this.canEdit;
    }

    public void setCanEdit(boolean canEdit) {
        this.canEdit = canEdit;
    }

    public void markAsErrorRecursively() {
        this.markAsError();
        this.getInnerElements().forEach(ObjectFieldDefinition::markAsErrorRecursively);
    }

    public void markAsError() {
        this.isError = true;
    }

    public boolean isError() {
        return this.isError;
    }

    public String getDwAccessor() {
        return this.dwAccessor;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ObjectFieldDefinition that = (ObjectFieldDefinition)o;
        return this.modifiers == that.modifiers && this.hasUnloadedChildren == that.hasUnloadedChildren && this.canEdit == that.canEdit && Objects.equals(this.name, that.name) && Objects.equals(this.className, that.className) && Objects.equals(this.value, that.value) && Objects.equals(this.innerElements, that.innerElements) && Objects.equals(this.path, that.path) && Objects.equals(this.dwAccessor, that.dwAccessor);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.className, this.value, this.innerElements, this.modifiers, this.path, this.hasUnloadedChildren, this.canEdit, this.dwAccessor);
    }
}

