/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.debugger.test;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.mule.runtime.api.streaming.bytes.CursorStreamProvider;
import org.mule.runtime.api.streaming.object.CursorIteratorProvider;
import org.mule.runtime.core.api.streaming.iterator.Consumer;
import org.mule.runtime.core.api.streaming.iterator.ConsumerStreamingIterator;
import org.mule.runtime.core.api.streaming.iterator.StreamingIterator;
import org.mule.runtime.core.api.streaming.object.InMemoryCursorIteratorConfig;
import org.mule.runtime.core.internal.streaming.bytes.ByteArrayCursorStreamProvider;
import org.mule.runtime.core.internal.streaming.object.InMemoryCursorIteratorProvider;

public class RuntimeUtils {
    public CursorStreamProvider createCursorStreamProvider(byte[] content) {
        return new ByteArrayCursorStreamProvider(content);
    }

    public CursorIteratorProvider createIteratorProvider(List<Object> data) {
        return new InMemoryCursorIteratorProvider(this.toStreamingIterator(data), InMemoryCursorIteratorConfig.getDefault());
    }

    private <T> StreamingIterator<T> toStreamingIterator(List<T> data) {
        return new ConsumerStreamingIterator(new TestConsumer(data));
    }

    private class TestConsumer<T>
    implements Consumer<T> {
        private final Iterator<T> delegate;
        private final int size;

        private TestConsumer(Collection<T> collection) {
            this.delegate = collection.iterator();
            this.size = collection.size();
        }

        public T consume() {
            return this.delegate.next();
        }

        public boolean isConsumed() {
            return !this.delegate.hasNext();
        }

        public void close() {
        }

        public int getSize() {
            return this.size;
        }
    }
}

