/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.debugger.transport;

import com.mulesoft.mule.debugger.request.ErrorRequest;
import com.mulesoft.mule.debugger.request.ExitDebuggerRequest;
import com.mulesoft.mule.debugger.request.IDebuggerRequest;
import com.mulesoft.mule.debugger.response.ErrorResponse;
import com.mulesoft.mule.debugger.response.ExitDebuggerResponse;
import com.mulesoft.mule.debugger.response.IDebuggerResponse;
import com.mulesoft.mule.debugger.transport.IClientDebuggerProtocol;
import com.mulesoft.mule.debugger.transport.IServerDebuggerProtocol;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerializeDebuggerProtocol
implements IClientDebuggerProtocol,
IServerDebuggerProtocol {
    protected static final Logger LOGGER = LoggerFactory.getLogger(SerializeDebuggerProtocol.class);
    private ObjectInputStream input;
    private ObjectOutputStream output;
    private final Lock singleSend = new ReentrantLock();

    public SerializeDebuggerProtocol(InputStream input, OutputStream output) {
        try {
            this.output = new ObjectOutputStream(output);
            this.input = new ObjectInputStream(input);
        }
        catch (IOException e) {
            LOGGER.error("Error creating stream", (Throwable)e);
        }
    }

    @Override
    public void sendRequest(IDebuggerRequest request) {
        try {
            this.singleSend.lock();
            this.output.reset();
            this.output.writeObject(request);
            this.output.flush();
        }
        catch (IOException e) {
            LOGGER.error("Error when sending request", (Throwable)e);
        }
        finally {
            this.singleSend.unlock();
        }
    }

    @Override
    public IDebuggerResponse getResponse() {
        try {
            return (IDebuggerResponse)this.input.readObject();
        }
        catch (IOException e) {
            return new ExitDebuggerResponse();
        }
        catch (Exception e) {
            return new ErrorResponse(e.getMessage());
        }
    }

    @Override
    public IDebuggerRequest getRequest() {
        try {
            return (IDebuggerRequest)this.input.readObject();
        }
        catch (IOException e) {
            return new ExitDebuggerRequest();
        }
        catch (Exception e) {
            return new ErrorRequest(e);
        }
    }

    @Override
    public void sendResponse(IDebuggerResponse response) {
        try {
            this.singleSend.lock();
            this.output.reset();
            this.output.writeObject(response);
            this.output.flush();
        }
        catch (IOException e) {
            LOGGER.error("Error when sending response", (Throwable)e);
        }
        finally {
            this.singleSend.unlock();
        }
    }

    @Override
    public void close() {
        try {
            this.output.close();
        }
        catch (IOException e) {
            LOGGER.error("Error when closing output stream", (Throwable)e);
        }
        try {
            this.input.close();
        }
        catch (IOException e) {
            LOGGER.error("Error when closing input stream", (Throwable)e);
        }
    }
}

