/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.debugger.util;

import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class DataWeaveUtils {
    private static final Pattern VALID_DW_IDENTIFIER_PATTERN = Pattern.compile("^[a-zA-Z][a-zA-Z0-9_]*$");
    static final Set<String> DW_IDENTIFIERS = Stream.of("if", "else", "unless", "using", "---", "as", "is", "null", "true", "false", "default", "case", "fun", "input", "output", "ns", "type", "import", "var", "and", "or", "throw", "do", "for", "yield", "enum", "private", "async").collect(Collectors.toSet());

    private DataWeaveUtils() {
        throw new IllegalStateException("Not meant to be instanciated");
    }

    static boolean isValidIdentifier(String name) {
        return VALID_DW_IDENTIFIER_PATTERN.matcher(name).matches() && !DW_IDENTIFIERS.contains(name);
    }

    public static String appendSelector(String prefixExpression, Object key, int index) {
        return key instanceof String ? DataWeaveUtils.appendSelector(prefixExpression, (String)key) : DataWeaveUtils.appendIndex(prefixExpression, index);
    }

    public static String appendIndex(String prefixExpression, int index) {
        return prefixExpression + "[" + index + "]";
    }

    public static String appendSelector(String prefixExpression, String identifier) {
        String postfixExpression = DataWeaveUtils.isValidIdentifier(identifier) ? "." + identifier : ".'" + identifier + "'";
        return prefixExpression + postfixExpression;
    }
}

