/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.analytics;

import com.mulesoft.mule.runtime.gw.analytics.cache.AnalyticsEventCacheManager;
import com.mulesoft.mule.runtime.gw.api.analytics.AnalyticsHttpEvent;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnalyticsEventDispatcher {
    private static final Logger LOGGER = LoggerFactory.getLogger(AnalyticsEventDispatcher.class);
    private final AnalyticsEventCacheManager cacheManager;

    public AnalyticsEventDispatcher(AnalyticsEventCacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    public void dispatch(AnalyticsHttpEvent event) {
        if (this.isPolicyViolation(event)) {
            this.processPolicyViolation(event);
        } else {
            LOGGER.trace("Adding event to the analytics queue. Event details: {}", (Object)event);
            this.cacheManager.getRegularEventsCache().offer(event);
        }
    }

    private void processPolicyViolation(AnalyticsHttpEvent event) {
        LOGGER.trace("Adding policy violation event to the policy violations queue. Event details: {}", (Object)event);
        if (!this.cacheManager.getPolicyViolationsCache().offer(event) && LOGGER.isTraceEnabled()) {
            LOGGER.trace("A violation attempt event against policy ID {} {}  will be dropped. The policy violations threshold was exceeded.", (Object)event.getPolicyViolation().getPolicyId(), (Object)(StringUtils.isNotBlank((CharSequence)event.getClientId()) ? " by client ID " + event.getClientId() : ""));
        }
    }

    private boolean isPolicyViolation(AnalyticsHttpEvent event) {
        return event.getPolicyViolation() != null;
    }
}

