/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.analytics;

import com.mulesoft.mule.runtime.gw.analytics.AnalyticsEventDispatcher;
import com.mulesoft.mule.runtime.gw.analytics.cache.AnalyticsEventCacheManager;
import com.mulesoft.mule.runtime.gw.analytics.model.AnalyticsEventBuilder;
import com.mulesoft.mule.runtime.gw.analytics.model.AnalyticsHttpEventBuilder;
import com.mulesoft.mule.runtime.gw.analytics.notification.EnrichedServerNotificationExtractor;
import com.mulesoft.mule.runtime.gw.api.analytics.PolicyViolation;
import com.mulesoft.mule.runtime.gw.api.analytics.PolicyViolationOutcome;
import com.mulesoft.mule.runtime.gw.client.ApiPlatformClient;
import com.mulesoft.mule.runtime.gw.deployment.ApiService;
import com.mulesoft.mule.runtime.gw.model.Api;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.mule.runtime.api.component.location.ConfigurationComponentLocator;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.notification.EnrichedServerNotification;
import org.mule.runtime.core.api.construct.Flow;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnalyticsEventHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(AnalyticsEventHandler.class);
    private final ApiService apiService;
    private final ApiPlatformClient restClient;
    private final AnalyticsEventDispatcher eventDispatcher;
    private final EnrichedServerNotificationExtractor extractor;
    private final Map<String, AnalyticsEventBuilder> eventBuilders = new ConcurrentHashMap<String, AnalyticsEventBuilder>();

    public AnalyticsEventHandler(ApiService apiService, ConfigurationComponentLocator componentLocator, AnalyticsEventCacheManager cacheManager, ApiPlatformClient restClient) {
        this.apiService = apiService;
        this.eventDispatcher = new AnalyticsEventDispatcher(cacheManager);
        this.restClient = restClient;
        this.extractor = new EnrichedServerNotificationExtractor(componentLocator);
    }

    public void createEvent(EnrichedServerNotification notification) {
        Flow flow;
        Optional api;
        if (!this.eventBuilders.containsKey(this.extractor.eventId(notification)) && (api = this.apiService.find(flow = this.extractor.flow(notification))).isPresent() && ((Api)api.get()).getTrackingInfo().isTracked()) {
            LOGGER.debug("Processing Message Received Notification for '{}'", (Object)((Api)api.get()).getKey());
            AnalyticsHttpEventBuilder eventBuilder = new AnalyticsHttpEventBuilder().withId(this.extractor.eventId(notification)).withApi((Api)api.get()).withOrgId(this.restClient.getOrgId()).withReceivedTimestamp(notification.getTimestamp()).withRequestAttributes(notification.getEvent().getMessage().getAttributes());
            this.eventBuilders.put(this.extractor.eventId(notification), (AnalyticsEventBuilder)eventBuilder);
        }
    }

    public void finishEvent(EnrichedServerNotification notification) {
        AnalyticsEventBuilder eventBuilder = this.eventBuilders.remove(this.extractor.eventId(notification));
        if (eventBuilder != null) {
            LOGGER.debug("Processing Message Response Notification for '{}'", (Object)eventBuilder.getApiDescription());
            Object payload = notification.getEvent().getMessage().getPayload().getValue();
            TypedValue attributes = notification.getEvent().getMessage().getAttributes();
            eventBuilder.withResponse(payload, attributes).withRepliedTimestamp(notification.getTimestamp());
            this.extractor.client(notification).ifPresent(arg_0 -> ((AnalyticsEventBuilder)eventBuilder).withClient(arg_0));
            this.eventDispatcher.dispatch(eventBuilder.build());
        }
    }

    public void markPolicyViolation(String eventId, String policyId, String policyName) {
        AnalyticsEventBuilder eventBuilder = this.eventBuilders.get(eventId);
        if (eventBuilder != null) {
            LOGGER.debug("Processing Policy Violation Notification for '{}'", (Object)this.eventBuilders.get(eventId).getApiDescription());
            PolicyViolation policyViolation = PolicyViolation.builder().withPolicyId(policyId).withPolicyName(policyName).withOutcome(PolicyViolationOutcome.VIOLATION).build();
            eventBuilder.withPolicyViolation(policyViolation);
        }
    }
}

