/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.analytics.cache;

import com.mulesoft.mule.runtime.gw.analytics.cache.AnalyticsEventCache;
import com.mulesoft.mule.runtime.gw.api.analytics.AnalyticsHttpEvent;
import com.mulesoft.mule.runtime.gw.config.AnalyticsConfiguration;
import com.mulesoft.mule.runtime.gw.queue.SizeLimitedQueue;
import com.mulesoft.mule.runtime.gw.queue.SizeLimitedQueueFactory;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.BlockingQueue;
import java.util.function.Function;
import org.apache.commons.io.FileUtils;
import org.mapdb.DB;
import org.mapdb.DBMaker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnalyticsEventCacheManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(AnalyticsEventCacheManager.class);
    private static final String ANALYTICS_QUEUE_NAME = "events-queue";
    private static final String POLICY_VIOLATIONS_QUEUE_NAME = "policy-violations-queue";
    private static final String CACHE_DATA_FILE_EXT = ".p";
    private AnalyticsConfiguration configuration;
    private List<DB> dbs = new ArrayList<DB>();
    private AnalyticsEventCache regularEventsCache;
    private AnalyticsEventCache policyViolationsCache;

    public AnalyticsEventCacheManager(AnalyticsConfiguration configuration) {
        this.configuration = configuration;
        SizeLimitedQueueFactory factory = new SizeLimitedQueueFactory();
        this.regularEventsCache = this.createRegularEventCache(factory);
        this.policyViolationsCache = this.createPolicyViolationsCache(factory);
    }

    public AnalyticsEventCache getRegularEventsCache() {
        return this.regularEventsCache;
    }

    public AnalyticsEventCache getPolicyViolationsCache() {
        return this.policyViolationsCache;
    }

    public void close() {
        this.dbs.forEach(DB::close);
    }

    private AnalyticsEventCache createRegularEventCache(SizeLimitedQueueFactory factory) {
        DB db = this.createDb(this.configuration.getAnalyticsCacheFile(), ANALYTICS_QUEUE_NAME);
        this.dbs.add(db);
        BlockingQueue regularQueue = db.getQueue(ANALYTICS_QUEUE_NAME);
        return new AnalyticsEventCache(factory.createCircularQueue((Queue)regularQueue, (long)this.configuration.getCacheCapacity()), ANALYTICS_QUEUE_NAME);
    }

    private AnalyticsEventCache createPolicyViolationsCache(SizeLimitedQueueFactory factory) {
        DB db = this.createDb(this.configuration.getAnalyticsPolicyViolationsCacheFile(), POLICY_VIOLATIONS_QUEUE_NAME);
        this.dbs.add(db);
        BlockingQueue violationsQueue = db.getQueue(ANALYTICS_QUEUE_NAME);
        Function<AnalyticsHttpEvent, String> partitioner = event -> {
            Objects.requireNonNull(event.getPolicyViolation(), "Policy violation must be present in the Analytics event for this queue");
            return event.getPolicyViolation().getPolicyId().toString();
        };
        return new AnalyticsEventCache((SizeLimitedQueue)factory.createCircularPartitionedQueue((Queue)violationsQueue, (long)this.configuration.getPolicyViolationsCacheCapacity(), (long)this.configuration.getPolicyViolationThreshold(), partitioner), POLICY_VIOLATIONS_QUEUE_NAME);
    }

    private DB createDb(File cacheFile, String cacheName) {
        DB db;
        try {
            db = this.makeDB(cacheFile);
        }
        catch (Throwable throwable) {
            LOGGER.warn("There was an error attempting to open {}. Resetting it to its factory settings. {}", (Object)cacheName, (Object)throwable);
            FileUtils.deleteQuietly((File)cacheFile);
            FileUtils.deleteQuietly((File)new File(cacheFile.getAbsolutePath() + CACHE_DATA_FILE_EXT));
            db = this.makeDB(cacheFile);
        }
        return db;
    }

    private DB makeDB(File file) {
        return DBMaker.newFileDB((File)file).transactionDisable().mmapFileEnable().asyncWriteEnable().closeOnJvmShutdown().deleteFilesAfterClose().make();
    }
}

