/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.analytics.notification;

import com.mulesoft.mule.runtime.gw.analytics.AnalyticsEventHandler;
import com.mulesoft.mule.runtime.gw.analytics.model.HttpResponseAttributes;
import com.mulesoft.mule.runtime.gw.analytics.model.HttpStatusCodeMatcher;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.notification.IntegerAction;
import org.mule.runtime.api.notification.PolicyNotification;
import org.mule.runtime.api.notification.PolicyNotificationListener;

public class AnalyticsPolicyNotificationListener
implements PolicyNotificationListener<PolicyNotification> {
    private static final int EVENT_ID_LENGTH = 38;
    private final AnalyticsEventHandler eventHandler;
    private final String policyName;
    private final String policyId;
    private final HttpStatusCodeMatcher statusCodeMatcher;
    private Map<String, Integer> statusCodePerEvent = new ConcurrentHashMap<String, Integer>();

    public AnalyticsPolicyNotificationListener(AnalyticsEventHandler eventHandler, String policyId, String policyName) {
        this.eventHandler = eventHandler;
        this.policyId = policyId;
        this.policyName = policyName;
        this.statusCodeMatcher = new HttpStatusCodeMatcher();
    }

    public void onNotification(PolicyNotification notification) {
        String eventId = notification.getEvent().getContext().getId().substring(0, 38);
        if (this.isAfterNext(notification)) {
            HttpResponseAttributes.from((TypedValue)notification.getEvent().getMessage().getAttributes()).ifPresent(attributes -> this.statusCodePerEvent.put(eventId, attributes.getStatusCode()));
        } else if (this.isProcessEnd(notification)) {
            HttpResponseAttributes.from((TypedValue)notification.getEvent().getMessage().getAttributes()).ifPresent(attributes -> {
                Integer currentstatusCode;
                Integer previousStatusCode = this.statusCodePerEvent.remove(eventId);
                if (this.isPolicyViolation(previousStatusCode, currentstatusCode = Integer.valueOf(attributes.getStatusCode()))) {
                    this.eventHandler.markPolicyViolation(eventId, this.policyId, this.policyName);
                }
            });
        }
    }

    private boolean isPolicyViolation(Integer previousStatusCode, Integer currentstatusCode) {
        return (previousStatusCode == null || !this.statusCodeMatcher.isError(previousStatusCode.intValue())) && this.statusCodeMatcher.isError(currentstatusCode.intValue());
    }

    private boolean isAfterNext(PolicyNotification notification) {
        return new IntegerAction(2103).equals((Object)notification.getAction());
    }

    private boolean isProcessEnd(PolicyNotification notification) {
        return new IntegerAction(2104).equals((Object)notification.getAction());
    }
}

