/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.api.policy;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.List;
import java.util.regex.Pattern;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.core.api.policy.PolicyPointcut;
import org.mule.runtime.http.policy.api.HttpPolicyPointcutParameters;
import org.mule.runtime.policy.api.PolicyPointcutParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpHeaderPointcut
implements PolicyPointcut,
Serializable {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpHeaderPointcut.class);
    private final String name;
    private final Pattern valuePattern;

    public HttpHeaderPointcut(String name, String valuePattern) {
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkNotNull((Object)valuePattern);
        this.name = name;
        this.valuePattern = Pattern.compile(valuePattern);
    }

    public boolean matches(PolicyPointcutParameters parameters) {
        parameters = parameters.getSourceParameters().orElse(parameters);
        try {
            MultiMap headers = ((HttpPolicyPointcutParameters)parameters).getHeaders();
            List allValues = headers.getAll((Object)this.name);
            boolean matches = allValues.stream().anyMatch(v -> this.valuePattern.matcher((CharSequence)v).matches());
            if (LOGGER.isTraceEnabled()) {
                if (!matches) {
                    LOGGER.trace("Request {{}, {}} does not match the following header pointcut: {}", new Object[]{this.name, allValues.isEmpty() ? "<Not Present>" : allValues, this});
                } else {
                    LOGGER.trace("Request {{}, {}} matches the following header pointcut: {}", new Object[]{this.name, allValues, this});
                }
            }
            return matches;
        }
        catch (ClassCastException e) {
            LOGGER.trace("Invalid parameters type found. {}", (Object)e.getMessage());
            return false;
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HttpHeaderPointcut that = (HttpHeaderPointcut)o;
        return this.name.equals(that.name) && this.valuePattern.toString().equals(that.valuePattern.toString());
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.valuePattern.toString().hashCode();
        return result;
    }

    public String toString() {
        return "{name=" + this.name + ", value=" + this.valuePattern + "}";
    }
}

