/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.http.policy.api;

import java.util.Objects;
import org.mule.api.annotation.NoExtend;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.policy.api.PolicyPointcutParameters;

@NoExtend
public abstract class HttpPolicyPointcutParameters
extends PolicyPointcutParameters {
    private final String path;
    private final String method;
    private final MultiMap<String, String> headers;

    public HttpPolicyPointcutParameters(Component component, String path, String method) {
        this(component, null, path, method);
    }

    public HttpPolicyPointcutParameters(Component component, PolicyPointcutParameters sourceParameters, String path, String method) {
        this(component, sourceParameters, path, method, (MultiMap<String, String>)MultiMap.emptyMultiMap());
    }

    public HttpPolicyPointcutParameters(Component component, PolicyPointcutParameters sourceParameters, String path, String method, MultiMap<String, String> headers) {
        super(component, sourceParameters);
        this.path = path;
        this.method = method;
        this.headers = headers;
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public MultiMap<String, String> getHeaders() {
        return this.headers;
    }

    public int hashCode() {
        return Objects.hash(this.getComponent(), this.getSourceParameters(), this.method, this.path, this.getHeaders());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        HttpPolicyPointcutParameters other = (HttpPolicyPointcutParameters)((Object)obj);
        return Objects.equals(this.getComponent(), other.getComponent()) && Objects.equals(this.getSourceParameters(), other.getSourceParameters()) && Objects.equals(this.method, other.method) && Objects.equals(this.path, other.path) && Objects.equals(this.getHeaders(), other.getHeaders());
    }
}

