/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.analytics;

import com.mulesoft.mule.runtime.gw.api.policy.PolicyTemplateKey;
import com.mulesoft.mule.runtime.gw.model.Api;
import com.mulesoft.mule.runtime.gw.model.PolicyConfiguration;
import com.mulesoft.mule.runtime.gw.model.PolicyDefinition;
import com.mulesoft.mule.runtime.gw.notification.ApiDeploymentListener;
import com.mulesoft.mule.runtime.gw.policies.OfflinePolicyDefinition;
import com.mulesoft.mule.runtime.gw.policies.deployment.InternalPolicyDeployer;
import com.mulesoft.mule.runtime.gw.policies.deployment.PolicyDeployer;
import java.util.Collections;
import org.mule.runtime.core.api.config.MuleManifest;

public class AnalyticsApiDeploymentListener
implements ApiDeploymentListener {
    private static final String ANALYTICS_POLICY_ID = "analytics-policy";
    private static final PolicyTemplateKey ANALYTICS_POLICY_TEMPLATE_KEY = new PolicyTemplateKey("com.mulesoft.anypoint", "mule-analytics-policy-template", MuleManifest.getProductVersion());
    private PolicyDeployer policyDeployer = new InternalPolicyDeployer();

    public void onApiDeploymentSuccess(Api api) {
        if (!api.getImplementation().isHdp()) {
            OfflinePolicyDefinition policyDefinition = new OfflinePolicyDefinition(this.getPolicyId(api), ANALYTICS_POLICY_TEMPLATE_KEY, api.getImplementation().getApiKey(), Collections.emptyList(), 1, new PolicyConfiguration(Collections.emptyMap()));
            this.policyDeployer.deploy((PolicyDefinition)policyDefinition, api);
        }
    }

    private String getPolicyId(Api api) {
        return "analytics-policy-" + api.getKey().id();
    }
}

