/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.analytics;

import com.mulesoft.mule.runtime.gw.analytics.AnalyticsApiDeploymentListener;
import com.mulesoft.mule.runtime.gw.analytics.AnalyticsEventHandler;
import com.mulesoft.mule.runtime.gw.analytics.AnalyticsEventHandlerManager;
import com.mulesoft.mule.runtime.gw.analytics.AnalyticsPollersManager;
import com.mulesoft.mule.runtime.gw.analytics.cache.AnalyticsEventCacheManager;
import com.mulesoft.mule.runtime.gw.analytics.notification.AnalyticsConnectorMessageNotificationListener;
import com.mulesoft.mule.runtime.gw.analytics.notification.AnalyticsNotificationListenerSupplier;
import com.mulesoft.mule.runtime.gw.api.service.EventsCollectorService;
import com.mulesoft.mule.runtime.gw.autodiscovery.ApiDiscovery;
import com.mulesoft.mule.runtime.gw.backoff.scheduler.factory.BackoffSchedulerFactory;
import com.mulesoft.mule.runtime.gw.backoff.scheduler.factory.VariableExecutorBackoffSchedulerFactory;
import com.mulesoft.mule.runtime.gw.client.provider.ApiPlatformClientProvider;
import com.mulesoft.mule.runtime.gw.config.AnalyticsConfiguration;
import com.mulesoft.mule.runtime.gw.deployment.ApiDeploymentCoreExtension;
import com.mulesoft.mule.runtime.gw.extension.GatewayEntitledCoreExtension;
import com.mulesoft.mule.runtime.gw.logging.LoggingClassLoaderSelector;
import com.mulesoft.mule.runtime.gw.policies.notification.PolicyNotificationListenerSupplier;
import javax.inject.Inject;
import org.mule.runtime.api.artifact.Registry;
import org.mule.runtime.api.component.location.ConfigurationComponentLocator;
import org.mule.runtime.api.config.custom.CustomizationService;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.notification.ConnectorMessageNotification;
import org.mule.runtime.api.notification.ConnectorMessageNotificationListener;
import org.mule.runtime.api.notification.NotificationListener;
import org.mule.runtime.api.notification.NotificationListenerRegistry;
import org.mule.runtime.container.api.MuleCoreExtensionDependency;
import org.mule.runtime.core.api.context.notification.ServerNotificationManager;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.module.deployment.api.DeploymentListener;
import org.mule.runtime.module.deployment.api.DeploymentService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnalyticsCoreExtension
extends GatewayEntitledCoreExtension {
    public static final String ANALYTICS_QUEUE = "_analyticsQueue";
    public static final String ANALYTICS_POLICY_VIOLATION_QUEUE = "_analyticsPolicyViolationQueue";
    private static final Logger LOGGER = LoggerFactory.getLogger(AnalyticsCoreExtension.class);
    @Inject
    private DeploymentService deploymentService;
    @Inject
    private EventsCollectorService eventsCollectorService;
    private ApiDeploymentCoreExtension apiDeploymentCoreExtension;
    private AnalyticsPollersManager pollersManager;
    private ApiPlatformClientProvider restClientProvider;
    private AnalyticsEventHandlerManager eventHandlerManager;
    private AnalyticsEventCacheManager cacheManager;
    private AnalyticsConfiguration configuration = new AnalyticsConfiguration();
    private ApiDiscovery apiDiscovery;
    private boolean firstAppDeployed;
    private boolean extensionInitialized;

    public AnalyticsCoreExtension() {
        this.restClientProvider = new ApiPlatformClientProvider(null);
        this.apiDiscovery = new ApiDiscovery();
    }

    public String getName() {
        return "Analytics Collector Extension";
    }

    public synchronized void initialiseCoreExtension() {
    }

    public void finishLazyInitialization() {
        if (!this.extensionInitialized && this.analyticsEnabled()) {
            LOGGER.debug("Starting {}", (Object)this.getName());
            this.deploymentService.addDomainDeploymentListener((DeploymentListener)this);
            this.initializeCache();
            this.eventHandlerManager = new AnalyticsEventHandlerManager(this.apiDeploymentCoreExtension.getApiService(), this.cacheManager, this.restClientProvider.getClient(), this.eventsCollectorService, this.configuration.isServiceMesh());
            this.apiDeploymentCoreExtension.getApiService().addDeploymentListener(new AnalyticsApiDeploymentListener());
            this.extensionInitialized = true;
        }
    }

    private synchronized void initializeCache() {
        if (!this.firstAppDeployed) {
            this.cacheManager = new AnalyticsEventCacheManager(this.configuration);
            this.cacheManager.initialise();
            this.apiDeploymentCoreExtension.getNotificationListenerSuppliers().add((PolicyNotificationListenerSupplier)new AnalyticsNotificationListenerSupplier(this.eventsCollectorService));
            this.cacheManager.getCloudCaches().ifPresent(caches -> {
                this.pollersManager = new AnalyticsPollersManager(this.configuration, caches, this.restClientProvider, (BackoffSchedulerFactory)new VariableExecutorBackoffSchedulerFactory());
                this.startSchedulers();
            });
            this.firstAppDeployed = true;
        }
    }

    public void start() {
    }

    public void onArtifactCreated(String artifactName, CustomizationService customizationService) {
        LoggingClassLoaderSelector.initialise((ClassLoader)Thread.currentThread().getContextClassLoader());
        ClassUtils.withContextClassLoader((ClassLoader)this.containerClassLoader.getClassLoader(), () -> {
            if (this.analyticsEnabled() && this.extensionLoaded() && this.onlineMode()) {
                customizationService.registerCustomServiceImpl("analytics-queues-registration", (Object)new ExtensionInitialisation(artifactName, this));
                this.initializeCache();
                this.cacheManager.getAgentCaches().ifPresent(caches -> {
                    customizationService.registerCustomServiceImpl(ANALYTICS_QUEUE, (Object)caches.getRegularEventsCache());
                    customizationService.registerCustomServiceImpl(ANALYTICS_POLICY_VIOLATION_QUEUE, (Object)caches.getViolationsEventsCache());
                });
            }
        });
    }

    public void onUndeploymentStart(String artifactName) {
        if (this.eventHandlerManager != null) {
            this.eventHandlerManager.remove(artifactName);
        }
    }

    public void stop() {
        if (this.pollersManager != null) {
            this.pollersManager.shutdown();
        }
    }

    public void dispose() {
        if (this.cacheManager != null) {
            this.cacheManager.dispose();
        }
    }

    @MuleCoreExtensionDependency
    public void setApiDeploymentCoreExtension(ApiDeploymentCoreExtension apiDeploymentCoreExtension) {
        this.apiDeploymentCoreExtension = apiDeploymentCoreExtension;
    }

    private void startSchedulers() {
        this.pollersManager.scheduleAnalyticsRunnable();
        this.pollersManager.schedulePolicyViolationsRunnable();
    }

    public boolean analyticsEnabled() {
        return this.configuration.isEnabled();
    }

    class ExtensionInitialisation
    implements Initialisable {
        private final String artifactName;
        private AnalyticsCoreExtension analyticsCoreExtension;
        @Inject
        private ServerNotificationManager notificationManager;
        @Inject
        private ConfigurationComponentLocator locator;
        @Inject
        private Registry registry;

        public ExtensionInitialisation(String artifactName, AnalyticsCoreExtension analyticsCoreExtension) {
            this.artifactName = artifactName;
            this.analyticsCoreExtension = analyticsCoreExtension;
        }

        public void initialise() {
            if (AnalyticsCoreExtension.this.onlineMode() || !AnalyticsCoreExtension.this.apiDiscovery.apiKeys(this.registry).isEmpty()) {
                this.analyticsCoreExtension.finishLazyInitialization();
                AnalyticsEventHandler eventHandler = AnalyticsCoreExtension.this.eventHandlerManager.create(this.artifactName, this.locator);
                ((NotificationListenerRegistry)this.registry.lookupByType(NotificationListenerRegistry.class).get()).registerListener((NotificationListener)new AnalyticsConnectorMessageNotificationListener(eventHandler));
                if (!this.notificationManager.getInterfaceToTypes().containsKey(ConnectorMessageNotificationListener.class)) {
                    this.notificationManager.addInterfaceToType(ConnectorMessageNotificationListener.class, ConnectorMessageNotification.class);
                }
            }
        }
    }
}

