/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.analytics;

import com.mulesoft.mule.runtime.gw.analytics.AnalyticsEventDispatcher;
import com.mulesoft.mule.runtime.gw.analytics.feedbackloop.FeedbackLoopDDOSHeaderInjector;
import com.mulesoft.mule.runtime.gw.analytics.model.AnalyticsEventBuilder;
import com.mulesoft.mule.runtime.gw.analytics.model.AnalyticsHttpEventBuilder;
import com.mulesoft.mule.runtime.gw.analytics.model.HttpRequestAttributes;
import com.mulesoft.mule.runtime.gw.analytics.model.HttpRequestAttributesFactory;
import com.mulesoft.mule.runtime.gw.analytics.notification.EnrichedServerNotificationExtractor;
import com.mulesoft.mule.runtime.gw.api.analytics.AnalyticsHttpEvent;
import com.mulesoft.mule.runtime.gw.api.service.EventsCollectorService;
import com.mulesoft.mule.runtime.gw.client.ApiPlatformClient;
import com.mulesoft.mule.runtime.gw.config.HighDensityProxyConfiguration;
import com.mulesoft.mule.runtime.gw.deployment.ApiService;
import com.mulesoft.mule.runtime.gw.model.Api;
import com.mulesoft.mule.runtime.gw.model.ApiImplementation;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.concurrent.ConcurrentHashMap;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.notification.EnrichedServerNotification;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.core.api.construct.Flow;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnalyticsEventHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(AnalyticsEventHandler.class);
    final ApiService apiService;
    private final ApiPlatformClient restClient;
    private final AnalyticsEventDispatcher eventDispatcher;
    private final EnrichedServerNotificationExtractor extractor;
    private final Map<String, AnalyticsEventBuilder> eventBuilders = new ConcurrentHashMap<String, AnalyticsEventBuilder>();
    private final EventsCollectorService eventsCollectorService;
    private final FeedbackLoopDDOSHeaderInjector headerInjector = new FeedbackLoopDDOSHeaderInjector();
    private final HttpRequestAttributesFactory httpRequestAttributesFactory = new HttpRequestAttributesFactory();
    private final HighDensityProxyConfiguration hdpConfiguration = new HighDensityProxyConfiguration();

    public AnalyticsEventHandler(ApiService apiService, EnrichedServerNotificationExtractor extractor, AnalyticsEventDispatcher eventDispatcher, ApiPlatformClient restClient, EventsCollectorService eventsCollectorService) {
        this.apiService = apiService;
        this.extractor = extractor;
        this.eventDispatcher = eventDispatcher;
        this.restClient = restClient;
        this.eventsCollectorService = eventsCollectorService;
    }

    public void startEvent(EnrichedServerNotification notification) {
        Flow flow;
        Optional<Api> api;
        if (!this.eventBuilders.containsKey(this.extractor.eventId(notification)) && (api = this.findApi(flow = this.extractor.flow(notification), notification)).isPresent() && api.get().getTrackingInfo().isTracked()) {
            LOGGER.debug("Processing Message Received Notification for '{}'", (Object)api.get().getKey());
            AnalyticsHttpEventBuilder eventBuilder = new AnalyticsHttpEventBuilder().withId(this.extractor.eventId(notification)).withApi(api.get()).withOrgId(this.restClient.getOrgId()).withReceivedTimestamp(notification.getTimestamp()).withRequestAttributes(notification.getEvent().getMessage().getAttributes());
            this.eventBuilders.put(this.key(notification, flow), (AnalyticsEventBuilder)eventBuilder);
        }
    }

    Optional<Api> findApi(Flow flow, EnrichedServerNotification notification) {
        Optional<Api> api = this.apiService.find(flow);
        if (api.isPresent() && (api.get().isOffline() || api.get().getImplementation().isHdp())) {
            api = this.findHdpApi(api.get().getImplementation(), notification);
        }
        return api;
    }

    private Optional<Api> findHdpApi(ApiImplementation apiImplementation, EnrichedServerNotification notification) {
        String service;
        TypedValue attributes = notification.getEvent().getMessage().getAttributes();
        Optional<MultiMap> headers = this.httpRequestAttributesFactory.from(attributes).map(HttpRequestAttributes::getHeaders);
        String serviceHeader = this.hdpConfiguration.getHdpServiceHeader();
        if (headers.isPresent() && headers.get().containsKey((Object)serviceHeader) && (service = (String)headers.get().get((Object)serviceHeader)) != null) {
            Optional<Api> hdpApi = this.apiService.findHdpApi(apiImplementation.getFlow(), service);
            if (!hdpApi.isPresent()) {
                LOGGER.warn("HDP Application {} has No API registered for service {}", (Object)apiImplementation.getArtifactName(), (Object)service);
            }
            return hdpApi;
        }
        LOGGER.warn("HDP Application {} hit with no service identifier", (Object)apiImplementation.getArtifactName());
        return Optional.empty();
    }

    public void finishEvent(EnrichedServerNotification notification) {
        AnalyticsEventBuilder eventBuilder = this.eventBuilders.remove(this.key(notification, this.extractor.flow(notification)));
        if (eventBuilder != null) {
            LOGGER.debug("Processing Message Response Notification for '{}'", (Object)eventBuilder.getApiDescription());
            OptionalLong payloadLength = notification.getEvent().getMessage().getPayload().getByteLength();
            TypedValue attributes = notification.getEvent().getMessage().getAttributes();
            eventBuilder.withResponse(payloadLength, attributes, notification.getAction()).withRepliedTimestamp(notification.getTimestamp());
            this.extractor.client(notification).ifPresent(arg_0 -> ((AnalyticsEventBuilder)eventBuilder).withClient(arg_0));
            this.eventsCollectorService.removePolicyViolation(this.extractor.eventId(notification)).ifPresent(policyViolation -> {
                eventBuilder.withPolicyViolation(policyViolation);
                if (eventBuilder.isEdgeRequest()) {
                    this.headerInjector.injectHeader(attributes.getValue(), policyViolation);
                }
            });
            this.dispatchEvent(eventBuilder.build(), attributes.getValue());
        }
    }

    void dispatchEvent(AnalyticsHttpEvent event, Object attributes) {
        this.eventDispatcher.dispatch(event);
    }

    private String key(EnrichedServerNotification notification, Flow flow) {
        return this.extractor.eventId(notification) + "-" + flow.getName();
    }
}

