/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.analytics;

import com.mulesoft.mule.runtime.gw.analytics.AnalyticsEventDispatcher;
import com.mulesoft.mule.runtime.gw.analytics.AnalyticsEventHandler;
import com.mulesoft.mule.runtime.gw.analytics.AnalyticsServiceMeshEventHandler;
import com.mulesoft.mule.runtime.gw.analytics.cache.AnalyticsEventCacheManager;
import com.mulesoft.mule.runtime.gw.analytics.notification.EnrichedServerNotificationExtractor;
import com.mulesoft.mule.runtime.gw.api.service.EventsCollectorService;
import com.mulesoft.mule.runtime.gw.client.ApiPlatformClient;
import com.mulesoft.mule.runtime.gw.deployment.ApiService;
import java.util.HashMap;
import java.util.Map;
import org.mule.runtime.api.component.location.ConfigurationComponentLocator;

public class AnalyticsEventHandlerManager {
    private final ApiService apiService;
    private final AnalyticsEventCacheManager cacheManager;
    private final ApiPlatformClient restClient;
    private Boolean serviceMesh;
    private final Map<String, AnalyticsEventHandler> handlers;
    private EventsCollectorService eventsCollectorService;

    public AnalyticsEventHandlerManager(ApiService apiService, AnalyticsEventCacheManager cacheManager, ApiPlatformClient restClient, EventsCollectorService eventsCollectorService, Boolean serviceMesh) {
        this.apiService = apiService;
        this.cacheManager = cacheManager;
        this.restClient = restClient;
        this.serviceMesh = serviceMesh;
        this.handlers = new HashMap<String, AnalyticsEventHandler>();
        this.eventsCollectorService = eventsCollectorService;
    }

    public AnalyticsEventHandler create(String appName, ConfigurationComponentLocator componentLocator) {
        EnrichedServerNotificationExtractor extractor = new EnrichedServerNotificationExtractor(componentLocator);
        AnalyticsEventHandler handler = this.serviceMesh != false ? new AnalyticsServiceMeshEventHandler(this.apiService, extractor, this.restClient, this.eventsCollectorService) : new AnalyticsEventHandler(this.apiService, extractor, new AnalyticsEventDispatcher(this.cacheManager), this.restClient, this.eventsCollectorService);
        this.handlers.put(appName, handler);
        return handler;
    }

    public AnalyticsEventHandler get(String appName) {
        return this.handlers.get(appName);
    }

    public void remove(String appName) {
        this.handlers.remove(appName);
    }
}

