/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.analytics.servicemesh;

import com.mulesoft.mule.runtime.gw.analytics.model.HttpAttributesIntrospector;
import com.mulesoft.mule.runtime.gw.analytics.model.Introspectors;
import com.mulesoft.mule.runtime.gw.api.analytics.AnalyticsHttpEvent;
import com.mulesoft.mule.runtime.gw.config.AnalyticsConfiguration;
import java.util.Base64;
import org.mule.runtime.http.api.domain.CaseInsensitiveMultiMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceMeshHeaderInjector {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServiceMeshHeaderInjector.class);
    public static final String SEPARATOR = "|";
    private final Introspectors<HttpAttributesIntrospector> introspectors = new Introspectors(HttpAttributesIntrospector::new);
    private final AnalyticsConfiguration configuration = new AnalyticsConfiguration();

    public void injectHeader(Object attributes, AnalyticsHttpEvent event) {
        try {
            HttpAttributesIntrospector introspector = (HttpAttributesIntrospector)this.introspectors.getFor(attributes.getClass());
            CaseInsensitiveMultiMap headers = new CaseInsensitiveMultiMap(introspector.getHeaders(attributes));
            headers.put((Object)this.configuration.getServiceMeshHeader(), (Object)this.generateCheckHeader(event));
            introspector.getHeadersField().set(attributes, headers);
        }
        catch (Exception e) {
            LOGGER.debug("Could not set the Analytics Service Mesh header " + this.configuration.getServiceMeshHeader() + " for the response event.", (Throwable)e);
        }
    }

    private String generateCheckHeader(AnalyticsHttpEvent event) {
        StringBuilder builder = new StringBuilder();
        builder.append(event.getOrgId()).append(SEPARATOR);
        builder.append(event.getApiId()).append(SEPARATOR);
        builder.append(event.getApiVersionId()).append(SEPARATOR);
        builder.append(event.getClientId()).append(SEPARATOR);
        builder.append(event.getRequestDisposition()).append(SEPARATOR);
        if (event.getPolicyViolation() != null) {
            builder.append(event.getPolicyViolation().getPolicyId()).append(SEPARATOR);
            builder.append(event.getPolicyViolation().getPolicyName()).append(SEPARATOR);
            builder.append(event.getPolicyViolation().getCategory()).append(SEPARATOR);
            builder.append(event.getPolicyViolation().getOutcome().getName());
        }
        String header = builder.toString();
        String encoded = Base64.getUrlEncoder().encodeToString(header.getBytes());
        LOGGER.debug("Injecting header: {} ({})", (Object)encoded, (Object)header);
        return encoded;
    }
}

