/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.api;

import java.io.File;
import org.mule.runtime.container.api.MuleFoldersUtil;

public class PolicyFolders {
    public static final String POLICY_TEMPLATES_FOLDER = "policy-templates";
    public static final String POLICIES_FOLDER = "policies";
    public static final String FAILED_POLICIES_FOLDER = "failed-policies";
    public static final String OFFLINE_POLICIES_FOLDER = "offline-policies";
    public static final String HDP_API_REGISTRY_FOLDER = "hdp-api-registry";

    private PolicyFolders() {
    }

    public static File getPolicyTemplatesFolder() {
        return PolicyFolders.createDirectoryIfNecessary(new File(PolicyFolders.getPoliciesFolder(), POLICY_TEMPLATES_FOLDER));
    }

    public static File getPolicyTemplatesTempFolder() {
        return new File(MuleFoldersUtil.getExecutionFolder(), POLICY_TEMPLATES_FOLDER);
    }

    public static File getPoliciesFolder() {
        return PolicyFolders.createDirectoryIfNecessary(new File(MuleFoldersUtil.getMuleHomeFolder(), POLICIES_FOLDER));
    }

    public static File getOfflinePoliciesFolder() {
        return PolicyFolders.createDirectoryIfNecessary(new File(PolicyFolders.getPoliciesFolder(), OFFLINE_POLICIES_FOLDER));
    }

    public static File createDirectoryIfNecessary(File directory) {
        if (!(directory.exists() && directory.isDirectory() || directory.mkdirs())) {
            throw new IllegalArgumentException("Required folder could not be created at " + directory.getAbsolutePath());
        }
        return directory;
    }
}

