/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.deployment;

import com.mulesoft.mule.runtime.gw.api.ApiContractsSupplier;
import com.mulesoft.mule.runtime.gw.api.agent.GatewayCoreExtension;
import com.mulesoft.mule.runtime.gw.api.agent.HealthCheck;
import com.mulesoft.mule.runtime.gw.api.config.GatewayConfiguration;
import com.mulesoft.mule.runtime.gw.api.key.ApiKey;
import com.mulesoft.mule.runtime.gw.api.logging.ExceptionDescriptor;
import com.mulesoft.mule.runtime.gw.api.service.ContractService;
import com.mulesoft.mule.runtime.gw.autodiscovery.ApiDiscovery;
import com.mulesoft.mule.runtime.gw.backoff.configuration.BackoffConfigurationSupplier;
import com.mulesoft.mule.runtime.gw.client.ApiPlatformClient;
import com.mulesoft.mule.runtime.gw.client.provider.ApiPlatformClientConnectionListener;
import com.mulesoft.mule.runtime.gw.client.provider.ApiPlatformClientProvider;
import com.mulesoft.mule.runtime.gw.deployment.ApiService;
import com.mulesoft.mule.runtime.gw.deployment.OfflineModeApiDeploymentListener;
import com.mulesoft.mule.runtime.gw.deployment.PlatformInteractionManager;
import com.mulesoft.mule.runtime.gw.deployment.contracts.ContractSnapshots;
import com.mulesoft.mule.runtime.gw.deployment.replication.ApiConfigurationCache;
import com.mulesoft.mule.runtime.gw.deployment.replication.DistributedApiConfigurationCache;
import com.mulesoft.mule.runtime.gw.deployment.replication.StandaloneApiConfigurationCache;
import com.mulesoft.mule.runtime.gw.deployment.service.CoreServicesClientsRepository;
import com.mulesoft.mule.runtime.gw.deployment.service.DefaultApiService;
import com.mulesoft.mule.runtime.gw.deployment.tracking.ApiTrackingService;
import com.mulesoft.mule.runtime.gw.deployment.tracking.DefaultApiTrackingService;
import com.mulesoft.mule.runtime.gw.extension.GatewayEntitledCoreExtension;
import com.mulesoft.mule.runtime.gw.internal.encryption.RuntimeEncrypterFactory;
import com.mulesoft.mule.runtime.gw.logging.LoggingClassLoaderSelector;
import com.mulesoft.mule.runtime.gw.notification.ApiDeploymentListener;
import com.mulesoft.mule.runtime.gw.policies.encryption.DefaultPolicyConfigurationEncrypter;
import com.mulesoft.mule.runtime.gw.policies.encryption.PolicyConfigurationEncrypter;
import com.mulesoft.mule.runtime.gw.policies.factory.DefaultPolicyFactory;
import com.mulesoft.mule.runtime.gw.policies.factory.EncryptedPolicyFactory;
import com.mulesoft.mule.runtime.gw.policies.factory.PolicyFactory;
import com.mulesoft.mule.runtime.gw.policies.lifecyle.DefaultHealthCheck;
import com.mulesoft.mule.runtime.gw.policies.lifecyle.GateKeeperSupplier;
import com.mulesoft.mule.runtime.gw.policies.lifecyle.HdpApisHealthCheckListener;
import com.mulesoft.mule.runtime.gw.policies.lifecyle.PolicyDeploymentListener;
import com.mulesoft.mule.runtime.gw.policies.notification.PolicyNotificationListenerSuppliers;
import com.mulesoft.mule.runtime.gw.policies.offline.OfflinePolicyWatcher;
import com.mulesoft.mule.runtime.gw.policies.service.DefaultPolicyDeploymentService;
import com.mulesoft.mule.runtime.gw.policies.service.DefaultPolicyDeploymentTracker;
import com.mulesoft.mule.runtime.gw.policies.service.DefaultPolicySetDeploymentService;
import com.mulesoft.mule.runtime.gw.policies.service.PolicyDeploymentService;
import com.mulesoft.mule.runtime.gw.policies.service.PolicyDeploymentTracker;
import com.mulesoft.mule.runtime.gw.policies.service.PolicySetDeploymentService;
import com.mulesoft.mule.runtime.gw.policies.store.DefaultPolicyStore;
import com.mulesoft.mule.runtime.gw.policies.store.EncryptedPropertiesSerializer;
import com.mulesoft.mule.runtime.gw.policies.store.PolicyStore;
import com.mulesoft.mule.runtime.gw.policies.template.provider.FileSystemPolicyTemplateProvider;
import com.mulesoft.mule.runtime.gw.policies.template.provider.PolicyTemplateProvider;
import com.mulesoft.mule.runtime.gw.policies.template.resolver.HandlebarsPolicyTemplateResolver;
import com.mulesoft.mule.runtime.gw.policies.template.resolver.PolicyTemplateResolver;
import com.mulesoft.mule.runtime.gw.retry.BackoffRunnableRetrierFactory;
import com.mulesoft.mule.runtime.gw.retry.RunnableRetrier;
import com.mulesoft.mule.runtime.module.cluster.api.ClusterCoreExtension;
import com.mulesoft.mule.runtime.module.cluster.api.notification.PrimaryClusterNodeListener;
import com.mulesoft.mule.runtime.module.cluster.internal.HazelcastClusterCoreExtension;
import com.mulesoft.mule.runtime.module.cluster.internal.HazelcastClusterManager;
import java.util.HashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.inject.Inject;
import org.mule.runtime.api.artifact.Registry;
import org.mule.runtime.api.config.custom.CustomizationService;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.healthcheck.HealthCheckValidator;
import org.mule.runtime.api.healthcheck.ReadyStatus;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.container.api.MuleCoreExtensionDependency;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.module.deployment.api.DeploymentListener;
import org.mule.runtime.module.deployment.api.DeploymentService;
import org.mule.runtime.module.deployment.api.StartupListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApiDeploymentCoreExtension
extends GatewayEntitledCoreExtension
implements GatewayCoreExtension,
PrimaryClusterNodeListener,
StartupListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(ApiDeploymentCoreExtension.class);
    private static final String AGW_HEALTHCHECK_HOLDER = "agw-healthcheck-holder";
    private final long startTime = System.currentTimeMillis();
    private final GatewayConfiguration configuration = new GatewayConfiguration();
    private final ApiPlatformClientProvider clientProvider;
    private final BackoffConfigurationSupplier backoffConfigurationSupplier = new BackoffConfigurationSupplier();
    private ApiDiscovery apiDiscovery;
    @Inject
    private ContractService contractService;
    @Inject
    private DeploymentService deploymentService;
    private ClusterCoreExtension clusterCoreExtension;
    private OfflinePolicyWatcher offlinePolicyWatcher;
    private ApiPlatformClient restClient;
    private PolicyNotificationListenerSuppliers notificationListenerSuppliers;
    private ApiService apiService;
    private ApiTrackingService apiTrackingService;
    private ApiConfigurationCache apiConfigurationCache;
    private ContractSnapshots contractSnapshots;
    private PlatformInteractionManager platformInteractionManager;
    private ApiDeploymentListener offlineModeDeploymentListener;
    private PolicySetDeploymentService policySetDeploymentService;
    private HealthCheck healthCheck;
    private boolean extensionInitialized;
    private boolean restClientInitialized;
    private boolean missingClientCredentialErrorShown;

    public ApiDeploymentCoreExtension() {
        this.clientProvider = new ApiPlatformClientProvider(this.platformConnectionRetrier());
    }

    public void initialiseCoreExtension() {
        this.apiDiscovery = new ApiDiscovery();
        this.notificationListenerSuppliers = new PolicyNotificationListenerSuppliers();
        this.apiService = new DefaultApiService(this.deploymentService);
    }

    public String getName() {
        return "API Gateway Extension";
    }

    public synchronized void finishLazyInitialization() {
        if (!this.extensionInitialized) {
            this.finishCoreExtensionInitialization();
            this.startCoreExtension();
            this.extensionInitialized = true;
        }
        if (!this.restClientInitialized) {
            if (this.onlineMode()) {
                this.initialiseRestClient();
            } else if (!this.missingClientCredentialErrorShown) {
                LOGGER.warn("Client ID or Client Secret were not provided. API Platform client is DISABLED.");
                this.missingClientCredentialErrorShown = true;
            }
        }
    }

    public void finishCoreExtensionInitialization() {
        HazelcastClusterManager hazelcastManager = ((HazelcastClusterCoreExtension)this.clusterCoreExtension).getHazelcastManager();
        if (hazelcastManager != null) {
            hazelcastManager.registerPrimaryNodeListener((PrimaryClusterNodeListener)this);
        }
        LOGGER.info("Starting {} in {} mode", (Object)this.getName(), (Object)(hazelcastManager != null ? "CLUSTERED" : "STANDALONE"));
        if (this.configuration.platformClient().isOnPrem().booleanValue()) {
            LOGGER.info("Running in On Prem mode.");
        }
        if (this.configuration.securityConfiguration().isEncryptionEnabled()) {
            LOGGER.debug("An encryption key is present. Policies and API contracts will be encrypted");
        } else {
            LOGGER.debug("No encryption key provided. Policies and API contracts won't be encrypted");
        }
        this.restClient = this.clientProvider.getClient();
        this.contractService.contractSupplier((ApiContractsSupplier)this.apiService);
        DefaultPolicyDeploymentTracker policyDeploymentTracker = new DefaultPolicyDeploymentTracker();
        DefaultPolicyStore policyStore = new DefaultPolicyStore(new EncryptedPropertiesSerializer());
        DefaultPolicyDeploymentService policyDeploymentService = new DefaultPolicyDeploymentService(this.apiService, this.notificationListenerSuppliers, (PolicyDeploymentTracker)policyDeploymentTracker, (PolicyStore)policyStore, this.getPolicyFactory());
        this.policySetDeploymentService = new DefaultPolicySetDeploymentService(this.policySetRetrier(), (PolicyDeploymentService)policyDeploymentService, (PolicyDeploymentTracker)policyDeploymentTracker, (PolicyStore)policyStore);
        this.offlinePolicyWatcher = new OfflinePolicyWatcher((PolicyDeploymentService)policyDeploymentService);
        this.contractSnapshots = new ContractSnapshots(this.apiService, (Lock)new ReentrantLock());
        this.apiConfigurationCache = hazelcastManager != null ? new DistributedApiConfigurationCache(this.apiService, this.policySetDeploymentService, this.contractSnapshots, hazelcastManager) : new StandaloneApiConfigurationCache(this.policySetDeploymentService);
        this.offlineModeDeploymentListener = new OfflineModeApiDeploymentListener(this.apiConfigurationCache, this.policySetDeploymentService);
        this.apiTrackingService = new DefaultApiTrackingService(this.apiService, this.policySetDeploymentService, this.apiConfigurationCache, this.contractSnapshots, this.contractService, this.configuration.onApiDeletedConfiguration());
        HdpApisHealthCheckListener hdpApisHealthCheckListener = new HdpApisHealthCheckListener(this.apiService);
        this.policySetDeploymentService.addPolicyDeploymentListener((PolicyDeploymentListener)hdpApisHealthCheckListener);
        this.apiService.addDeploymentListener(hdpApisHealthCheckListener);
        this.deploymentService.addDeploymentListener((DeploymentListener)this.apiService);
        this.apiService.addDeploymentListener((ApiDeploymentListener)this.policySetDeploymentService);
        this.apiService.addDeploymentListener(this.offlineModeDeploymentListener);
        this.offlinePolicyWatcher.initialise();
        this.apiConfigurationCache.initialise(this.apiTrackingService);
        this.healthCheck = new DefaultHealthCheck(this.apiService);
    }

    public void startCoreExtension() {
        this.deploymentService.addStartupListener((StartupListener)this);
        try {
            this.offlinePolicyWatcher.start();
        }
        catch (Exception e) {
            LOGGER.error("An unexpected exception was raised when loading in Gateway Pollers Core Extension. {}", (Object)ExceptionDescriptor.errorMessage((Throwable)e));
        }
        new GateKeeperSupplier(this.configuration.gateKeeper(), this.apiService).get().ifPresent(gateKeeper -> {
            this.policySetDeploymentService.addPolicyDeploymentListener((PolicyDeploymentListener)gateKeeper);
            this.apiService.addDeploymentListener((ApiDeploymentListener)gateKeeper);
        });
    }

    public void onArtifactCreated(String artifactName, CustomizationService customizationService) {
        LoggingClassLoaderSelector.initialise((ClassLoader)Thread.currentThread().getContextClassLoader());
        ClassUtils.withContextClassLoader((ClassLoader)this.containerClassLoader.getClassLoader(), () -> {
            if (this.extensionLoaded()) {
                customizationService.registerCustomServiceImpl("api-deployment-initialization", (Object)new ExtensionInitialisation(this));
                if (this.onlineMode()) {
                    customizationService.registerCustomServiceImpl("clients-repository", (Object)new CoreServicesClientsRepository(this.clientProvider.getClient()));
                }
                customizationService.registerCustomServiceImpl("hdp-apis-healthcheck", new HashMap());
                LOGGER.debug("HealthCheckValidatorHolder registered for application " + artifactName);
                customizationService.registerCustomServiceImpl(AGW_HEALTHCHECK_HOLDER, (Object)new HealthCheckValidatorHolder(artifactName));
            }
        });
    }

    public void start() {
    }

    public void stop() throws MuleException {
        this.removeSecretsFromSystem();
        this.clientProvider.shutdown();
        if (this.offlinePolicyWatcher != null) {
            this.offlinePolicyWatcher.stop();
        }
    }

    public void dispose() {
        if (this.platformInteractionManager != null) {
            this.platformInteractionManager.dispose();
        }
        if (this.offlinePolicyWatcher != null) {
            this.offlinePolicyWatcher.dispose();
        }
        LoggingClassLoaderSelector.dispose();
    }

    public void onNotification() {
        LOGGER.info("We have become the primary cluster node. Starting API Manager runnables");
        if (this.restClient.isConnected()) {
            this.platformInteractionManager.primaryNode();
        }
    }

    public void onAfterStartup() {
        if (LOGGER.isDebugEnabled()) {
            long elapsedTime = System.currentTimeMillis() - this.startTime;
            LOGGER.debug("-= All applications started (took " + elapsedTime + "ms)");
        }
    }

    @MuleCoreExtensionDependency
    public void setClusterCoreExtension(ClusterCoreExtension clusterCoreExtension) {
        this.clusterCoreExtension = clusterCoreExtension;
    }

    public ApiService getApiService() {
        return this.apiService;
    }

    public PolicyNotificationListenerSuppliers getNotificationListenerSuppliers() {
        return this.notificationListenerSuppliers;
    }

    public HealthCheck healthCheck() {
        return this.healthCheck;
    }

    void initialiseRestClient() {
        if (this.clientProvider.configureClient(this.configuration)) {
            this.platformInteractionManager = new PlatformInteractionManager(this.apiService, this.apiTrackingService, this.restClient, this.backoffConfigurationSupplier, this.isStandaloneOrPrimaryNode());
            this.clientProvider.addConnectionListener((ApiPlatformClientConnectionListener)this.platformInteractionManager);
            this.clientProvider.addConnectionListener(() -> this.apiService.removeDeploymentListener(this.offlineModeDeploymentListener));
            this.clientProvider.connectClient();
            this.restClientInitialized = true;
        }
    }

    private boolean isStandaloneOrPrimaryNode() {
        HazelcastClusterManager hazelcastManager = ((HazelcastClusterCoreExtension)this.clusterCoreExtension).getHazelcastManager();
        return hazelcastManager == null || hazelcastManager.isPrimaryPollingInstance();
    }

    private void removeSecretsFromSystem() {
        this.configuration.platformClient().clearClientSecret();
        this.configuration.securityConfiguration().clearEncryptionKey();
    }

    private RunnableRetrier<String> platformConnectionRetrier() {
        return new BackoffRunnableRetrierFactory().platformConnectionRetrier("agw-api-platform-connection-retry", this.configuration);
    }

    private RunnableRetrier<ApiKey> policySetRetrier() {
        return new BackoffRunnableRetrierFactory().policySetDeploymentServiceRetrier("agw-policy-set-deployment", this.configuration);
    }

    private PolicyFactory getPolicyFactory() {
        return this.configuration.securityConfiguration().isEncryptionEnabled() ? new EncryptedPolicyFactory((PolicyTemplateResolver)new HandlebarsPolicyTemplateResolver(), (PolicyTemplateProvider)new FileSystemPolicyTemplateProvider(this.restClient), (PolicyConfigurationEncrypter)new DefaultPolicyConfigurationEncrypter(RuntimeEncrypterFactory.createDefaultRuntimeEncrypter(), this.configuration.securityConfiguration().isSensitiveOnlyEncryption())) : new DefaultPolicyFactory((PolicyTemplateResolver)new HandlebarsPolicyTemplateResolver(), (PolicyTemplateProvider)new FileSystemPolicyTemplateProvider(this.restClient));
    }

    private static class HealthCheckValidatorHolder
    implements HealthCheckValidator {
        private String artifactName;
        private HealthCheckValidator validator;

        public HealthCheckValidatorHolder(String artifactName) {
            this.artifactName = artifactName;
        }

        void set(HealthCheck healthCheck) {
            LOGGER.debug("HealthCheckValidatorHolder initialized for application " + this.artifactName);
            this.validator = healthCheck.getValidator(this.artifactName);
        }

        public ReadyStatus ready() {
            if (this.validator != null) {
                return this.validator.ready();
            }
            return () -> true;
        }
    }

    class ExtensionInitialisation
    implements Initialisable {
        private ApiDeploymentCoreExtension apiDeploymentCoreExtension;
        @Inject
        private Registry registry;

        public ExtensionInitialisation(ApiDeploymentCoreExtension apiDeploymentCoreExtension) {
            this.apiDeploymentCoreExtension = apiDeploymentCoreExtension;
        }

        public void initialise() {
            ClassUtils.withContextClassLoader((ClassLoader)ApiDeploymentCoreExtension.this.containerClassLoader.getClassLoader(), () -> {
                if (ApiDeploymentCoreExtension.this.onlineMode() || !ApiDeploymentCoreExtension.this.apiDiscovery.apiKeys(this.registry).isEmpty()) {
                    this.apiDeploymentCoreExtension.finishLazyInitialization();
                }
                if (!ApiDeploymentCoreExtension.this.apiDiscovery.apiKeys(this.registry).isEmpty() || ApiDeploymentCoreExtension.this.apiService.isHighDensityProxy(this.registry)) {
                    this.registry.lookupByName(ApiDeploymentCoreExtension.AGW_HEALTHCHECK_HOLDER).ifPresent(h -> ((HealthCheckValidatorHolder)h).set(ApiDeploymentCoreExtension.this.healthCheck));
                }
            });
        }
    }
}

