/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.deployment.runnable;

import com.mulesoft.mule.runtime.gw.api.logging.ExceptionDescriptor;
import com.mulesoft.mule.runtime.gw.backoff.configuration.BackoffConfiguration;
import com.mulesoft.mule.runtime.gw.backoff.session.BackoffBarrier;
import com.mulesoft.mule.runtime.gw.backoff.session.SessionMetadata;
import com.mulesoft.mule.runtime.gw.client.exception.HttpResponseException;
import com.mulesoft.mule.runtime.gw.client.exception.NotFoundException;
import com.mulesoft.mule.runtime.gw.client.exception.UnauthorizedException;
import com.mulesoft.mule.runtime.gw.client.session.ApiPlatformSession;
import com.mulesoft.mule.runtime.gw.client.session.factory.ApiPlatformSessionFactory;
import com.mulesoft.mule.runtime.gw.deployment.runnable.GatewayPollerRunnable;
import com.mulesoft.mule.runtime.gw.deployment.tracking.ApiTrackingService;
import com.mulesoft.mule.runtime.gw.logging.GatewayMuleAppLoggerFactory;
import org.slf4j.Logger;

public class ApiKeepAliveRunnable
extends GatewayPollerRunnable {
    private static final Logger LOGGER = GatewayMuleAppLoggerFactory.getLogger(ApiKeepAliveRunnable.class);

    public ApiKeepAliveRunnable(ApiTrackingService apiTrackingService, ApiPlatformSessionFactory platformSessionFactory, BackoffBarrier backoffBarrier, BackoffConfiguration backoffConfiguration) {
        super(apiTrackingService, platformSessionFactory, backoffBarrier, backoffConfiguration);
    }

    protected SessionMetadata execute() {
        return this.profiledExecution(() -> {
            LOGGER.debug("Collecting sources across all applications");
            ApiPlatformSession platform = this.platformSessionFactory.create();
            this.apiTrackingService.getTrackedApis().forEach(api -> {
                try {
                    if (api.getImplementation().getFlow().getMuleContext().isStarted()) {
                        LOGGER.debug("Activating source for {}", api);
                        try {
                            platform.activateEndpoint(api.getTrackingInfo().getOrganizationId(), api.getTrackingInfo().getEnvironmentId(), api.getKey().id());
                        }
                        catch (NotFoundException e) {
                            this.apiTrackingService.apiUntracked(api.getKey());
                        }
                        catch (HttpResponseException e) {
                            LOGGER.error("Error activating {}. {}. Server status: {}", new Object[]{api, ExceptionDescriptor.errorMessage((Throwable)e), e.statusCode()});
                        }
                        catch (Exception e) {
                            LOGGER.error("Error activating {}. {}", api, (Object)ExceptionDescriptor.errorMessage((Throwable)e));
                        }
                    }
                }
                catch (UnauthorizedException e) {
                    LOGGER.error("Cannot get authorization to retrieve API information. {}", (Object)ExceptionDescriptor.errorMessage((Throwable)e));
                }
                catch (Exception e) {
                    LOGGER.error("Unexpected error occurred. {}", (Object)ExceptionDescriptor.errorMessage((Throwable)e));
                }
            });
            return platform.metadata();
        });
    }
}

